

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getClientOwnersWithParam.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getClientOwnersWithParam'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getClientOwnersWithParam]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getClientOwnersWithParam]
  delete from GXDBVersions where name = 'sec_getClientOwnersWithParam' and type = 5
END
GO

	CREATE FUNCTION sec_getClientOwnersWithParam(@clientId integer, @userID integer, @flags integer)
	RETURNS @ownersTable TABLE (clientId INT, userId INT, userGroupId INT)
	AS
	BEGIN
		DECLARE @userAndGroupsTable TABLE (userOrGroupId INT, isUser INT)
		IF @userID <> 0
		BEGIN
			INSERT INTO @userAndGroupsTable
						SELECT groupID, 0
						FROM UMUserGroup
						WHERE userID = @userID
						UNION
						SELECT UGM.umgroupId, 0
						FROM UMDSGroupMaps UGM INNER JOIN UMUserGroup UG
						ON UGM.umdsGroupId = UG.groupID
						WHERE userID = @userID
						UNION
						SELECT @userID, 1
		END
		IF (@clientId <> 0 AND @userID = 0)			--get owners of this client
		BEGIN
						INSERT INTO @ownersTable
							SELECT @clientId,
							   CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
							   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END
							FROM UMOwners Owners (NOLOCK)
							WHERE entityType = 1 AND entityId = 2		--use macro
						INSERT INTO @ownersTable
							SELECT @clientId,
								   CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
								   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END
							FROM UMOwners Owners INNER JOIN APP_ClientGroupAssoc CGA
							ON Owners.entityType = 28 AND Owners.entityID = CGA.clientGroupId		--use macro
							AND CGA.clientId = @clientID
						INSERT INTO @ownersTable
							SELECT @clientID,
								   CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
								   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END
							FROM UMOwners Owners
							WHERE Owners.entityType = 3 AND Owners.entityId = @clientID			--use macro
		END
		ELSE IF (@clientID = 0 AND @userId <> 0)			--get clients for whom userID is the owner
		BEGIN
				INSERT INTO @ownersTable
					SELECT Owners.entityId, @userId, 0
					FROM UMOwners Owners INNER JOIN @userAndGroupsTable UG
					ON Owners.isUser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId

		END
		ELSE IF (@clientID <> 0 AND @UserId <> 0)
		BEGIN
				IF EXISTS (SELECT 1
						   FROM UMOwners Owners INNER JOIN @userAndGroupsTable UG
						   ON Owners.isuser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId
						   WHERE Owners.entityType = 3 AND Owners.entityId = @clientId)
					INSERT INTO @ownersTable
						SELECT @clientID, @userID, 0


				ELSE IF EXISTS (SELECT 1
						   FROM UMOwners Owners INNER JOIN @userAndGroupsTable UG
						   ON Owners.isuser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId
						   WHERE Owners.entityType = 1 AND Owners.entityId = 2)
					INSERT INTO @ownersTable
						SELECT @clientID, @userID, 0



				ELSE IF EXISTS (SELECT 1
							   FROM UMOwners Owners INNER JOIN APP_ClientGroupAssoc CGA
							   ON Owners.entityType = 28 AND Owners.entityId = CGA.clientGroupId
							   INNER JOIN @userAndGroupsTable UG
							   ON Owners.isUser = UG.isUser AND Owners.userOrGroupId = UG.userOrGroupId
							   WHERE CGA.clientId = @clientID)
					INSERT INTO @ownersTable
						SELECT @clientId, @userID, 0

		END
		IF @flags = 1 AND @userID = 0				--have to expand user groups to users
		BEGIN
				INSERT INTO @ownersTable
					SELECT Tbl.clientID, 0, GM.umdsGroupId
					FROM @ownersTable Tbl INNER JOIN UMDSGroupMaps GM
					ON Tbl.userGroupId = GM.umgroupId

				INSERT INTO @ownersTable
					SELECT clientID, UM.userId, 0
					FROM @ownersTable Tbl INNER JOIN UMUserGroup UM
					ON Tbl.userGroupId = UM.groupId

		END


	--removing duplicate entries. This one is the more optimized and less tempDB consuming method
	--other methods tried were using a Id column and using WHERE NOT EXISTS before inserting entries into table

	;with cte as (
			select clientId, userId, userGroupId, rn = row_number() over(partition by clientId, userId, userGroupId order by clientId, userId, userGroupId)
			from @ownerstable
			)
		delete from cte where rn > 1
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getClientOwnersWithParam]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getClientOwnersWithParam' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getClientOwnersWithParam',  '', 'sec_getClientOwnersWithParam', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
