

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getClientOwners.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getClientOwners'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getClientOwners]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getClientOwners]
  delete from GXDBVersions where name = 'sec_getClientOwners' and type = 5
END
GO

    CREATE FUNCTION sec_getClientOwners(@flags integer)
	RETURNS @ownersTable TABLE (clientId INT, userId INT, userGroupId INT, externalGroupId INT)
	AS
	BEGIN
	IF dbo.isNewSecurity() = 1
	BEGIN
			INSERT INTO @ownersTable
				SELECT C.id,
			CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
					   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END,
   					   0
				FROM UMOwners Owners (NOLOCK) INNER JOIN APP_Client C (NOLOCK)
			ON Owners.entityType = 1 AND Owners.entityId = 2
			INSERT INTO @ownersTable
			SELECT CGA.clientId,
				   CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
					   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END,
   					   0
				FROM UMOwners Owners (NOLOCK) INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK)
				ON Owners.entityType = 28 AND Owners.entityID = CGA.clientGroupId
			INSERT INTO @ownersTable
			SELECT Owners.entityid,
				   CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
				   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END,
   				   0
				FROM UMOwners Owners (NOLOCK)
			WHERE Owners.entityType = 3
	END
	ELSE
	BEGIN
		INSERT INTO @ownersTable
			SELECT objectid, userId, CASE WHEN providerId = 0 THEN groupId ELSE 0 END, CASE WHEN providerId <> 0 THEN groupId ELSE 0 END
			FROM UMUserandGroupEntityAssociation (NOLOCK)
			WHERE entityType = 2009 AND (userId <> 0 OR groupId <> 0)
	END
	IF @flags = 1				--have to expand user groups to users
	BEGIN
			INSERT INTO @ownersTable
					SELECT Tbl.clientID, 0, GM.umdsGroupId, 0
					FROM @ownersTable Tbl INNER JOIN UMDSGroupMaps GM (NOLOCK)
				ON Tbl.userGroupId = GM.umgroupId

			INSERT INTO @ownersTable
				SELECT clientID, UM.userId, 0, 0
					FROM @ownersTable Tbl INNER JOIN UMUserGroup UM (NOLOCK)
				ON Tbl.userGroupId = UM.groupId

	END


		UPDATE o
		SET o.usergroupid = 0, o.externalgroupid = g.id
		FROM @ownerstable o INNER JOIN UMGroups g (NOLOCK)
		ON o.usergroupid = g.id
		WHERE o.usergroupid <> 0 and g.umdsProviderId > 0
	--removing duplicate entries. This one is the more optimized and less tempDB consuming method
	--other methods tried were using a Id column and using WHERE NOT EXISTS before inserting entries into table

	;with cte as (
			select clientId, userId, userGroupId, externalGroupId, rn = row_number() over(partition by clientId, userId, userGroupId, externalgroupid order by clientId, userId, userGroupId, externalgroupid)
			from @ownerstable
			)
		delete from cte where rn > 1
	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getClientOwners]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getClientOwners' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getClientOwners',  '', 'sec_getClientOwners', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
