

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getCapabilityBitMaskToPermissionMap.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getCapabilityBitMaskToPermissionMap'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getCapabilityBitMaskToPermissionMap]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getCapabilityBitMaskToPermissionMap]
  delete from GXDBVersions where name = 'sec_getCapabilityBitMaskToPermissionMap' and type = 5
END
GO

	CREATE FUNCTION dbo.sec_getCapabilityBitMaskToPermissionMap (@capabilities BIGINT, @shouldExpandPermissionsForCategory INT)
	RETURNS @permissionIdTbl TABLE
	(
	capabilityId INT,
	categoryId INT,
	permissionId INT
	)
	AS
	BEGIN
	DECLARE @capabilityTable TABLE (capabilityId INT)
	INSERT INTO @capabilityTable
		SELECT id
		FROM UMCapability
		WHERE CAST(POWER(2.0, id-1) AS BIGINT) & @capabilities <> 0
	INSERT INTO @permissionIdTbl
		SELECT DISTINCT Cap.capabilityId, Map.categoryId, Map.permissionId
		FROM @capabilityTable Cap CROSS APPLY sec_getCapabilityToPermissionMap(capabilityId, @shouldExpandPermissionsForCategory) Map
		WHERE Cap.capabilityId = Map.capabilityId

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getCapabilityBitMaskToPermissionMap]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getCapabilityBitMaskToPermissionMap' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getCapabilityBitMaskToPermissionMap',  '', 'sec_getCapabilityBitMaskToPermissionMap', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
