

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2VSADiscoveredClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2VSADiscoveredClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2VSADiscoveredClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2VSADiscoveredClients]
  delete from GXDBVersions where name = 'scgV2VSADiscoveredClients' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2VSADiscoveredClients (@operator VARCHAR(24), @VSAsubclientIds XML, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientID INT PRIMARY KEY)
AS
BEGIN
	--Read subclientIds from input XML.
	DECLARE @inputEntities TABLE (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
	INSERT INTO @inputEntities (clientId, appTypeId, instanceId, backupsetId, subclientId)
		SELECT ISNULL(ref.value('@clientId', 'INT'), 0), ISNULL(ref.value('@applicationId', 'INT'), 0), ISNULL(ref.value('@instanceId', 'INT'), 0), ISNULL(ref.value('@backupsetId', 'INT'), 0), ISNULL(ref.value('@subclientId', 'INT'), 0)
		FROM @VSAsubclientIds.nodes('App_Associations/entity') AS R(ref)
	DECLARE @subclientIds TABLE (subclientID INT PRIMARY KEY)
	INSERT INTO @subclientIds (subclientId)
		SELECT subclientId
		FROM @inputEntities
		WHERE subclientId > 0
		UNION
		SELECT A.id					--backupset to subclient expansion
		FROM @inputEntities I INNER JOIN APP_Application (NOLOCK) A
		ON I.backupsetId = A.backupSet
		WHERE I.backupsetId > 0 AND I.subclientId = 0
		UNION
		SELECT A.id					--instance to subclient expansion
		FROM @inputEntities I INNER JOIN APP_Application (NOLOCK) A
		ON I.instanceId = A.instance
		WHERE I.instanceId > 0 AND I.backupsetId = 0
		UNION
		SELECT A.id					--apptype to subclient expansion
		FROM @inputEntities I INNER JOIN APP_Application (NOLOCK) A
		ON I.appTypeID = A.appTypeID AND I.clientId = A.clientId
		WHERE I.appTypeId > 0 AND I.instanceId = 0
		UNION
		SELECT A.id					--client to subclient expansion
		FROM @inputEntities I INNER JOIN APP_APplication (NOLOCK) A
		ON I.clientID = A.clientID
		WHERE I.clientID > 0 AND I.appTypeID = 0 AND A.appTypeId = 106
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		--Equal to
		IF (@operator = '=')
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT CP.componentNameId
				FROM APP_ClientProp CP (NOLOCK) INNER JOIN @subclientIds SC
				ON CAST(CP.attrVal AS INT) = SC.subclientID
WHERE CP.attrName = 'VSA Discover Subclient ID' AND CP.modified = 0 AND CP.componentNameId > 1
		END
		--Not equal to
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT C.id
				FROM APP_Client C (NOLOCK)
				WHERE C.id > 1
				EXCEPT
				(SELECT DISTINCT CP.componentNameId
				FROM APP_ClientProp CP (NOLOCK) INNER JOIN @subclientIds SC
				ON CAST(CP.attrVal AS INT) = SC.subclientID
WHERE CP.attrName = 'VSA Discover Subclient ID' AND CP.modified = 0 AND CP.componentNameId > 1)
		END
	END
	ELSE
	BEGIN
		-- Given client
		--Equal to
		IF (@operator = '=')
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT CP.componentNameId
				FROM APP_ClientProp CP (NOLOCK) INNER JOIN @subclientIds SC
				ON CAST(CP.attrVal AS INT) = SC.subclientID
WHERE CP.attrName = 'VSA Discover Subclient ID' AND CP.modified = 0 AND CP.componentNameId = @inClientId
		END
		--Not equal to
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT C.id
				FROM APP_Client C (NOLOCK)
				WHERE C.id = @inClientId
				EXCEPT
				(SELECT DISTINCT CP.componentNameId
				FROM APP_ClientProp CP (NOLOCK) INNER JOIN @subclientIds SC
				ON CAST(CP.attrVal AS INT) = SC.subclientID
WHERE CP.attrName = 'VSA Discover Subclient ID' AND CP.modified = 0 AND CP.componentNameId = @inClientId)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2VSADiscoveredClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2VSADiscoveredClients' AND revision = '')

  insert into GXDBVersions values(5, 'scgV2VSADiscoveredClients',  '', 'scgV2VSADiscoveredClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
