

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2UserGroupClientAssociations.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2UserGroupClientAssociations'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2UserGroupClientAssociations]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2UserGroupClientAssociations]
  delete from GXDBVersions where name = 'scgV2UserGroupClientAssociations' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2UserGroupClientAssociations(@operator VARCHAR(16), @compValue NVARCHAR(256), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @Groups TABLE (
		groupId		INT PRIMARY KEY
	)
	IF (@opType = 1)
	BEGIN
		INSERT INTO @Groups(groupId)
			SELECT
				g.id
			FROM UMGroups G (NOLOCK)
				INNER JOIN UMDSProviders P ON
					G.umdsProviderID = P.id
					AND p.ServiceType IN (2,5)
			WHERE
				P.domainName + N'\' + g.name = @compValue
			UNION
			SELECT
				gm.umGroupId
			FROM UMGroups g WITH(NOLOCK)
				INNER JOIN UMDSGroupMaps gm WITH(NOLOCK) ON
					gm.umDSGroupId = g.id
				INNER JOIN UMDSProviders p WITH(NOLOCK) ON
					p.id = g.umDSProviderId
					AND p.serviceType IN (2, 5)		-- UMDS_PROVIDER_ACTIVE_DIR, UMDS_PROVIDER_ORGANIZATIONS
			WHERE
				(p.domainName + N'\' + g.name) = @compValue
	END
	ELSE IF (@opType = 2)
	BEGIN
		INSERT INTO @Groups(groupId)
			SELECT DISTINCT
				gm.umGroupId
			FROM UMGroups g WITH(NOLOCK)
				INNER JOIN UMDSGroupMaps gm WITH(NOLOCK) ON
					gm.umDSGroupId = g.id
				INNER JOIN UMDSProviders p WITH(NOLOCK) ON
					p.id = g.umDSProviderId
					AND p.serviceType IN (2, 5)		-- UMDS_PROVIDER_ACTIVE_DIR, UMDS_PROVIDER_ORGANIZATIONS
			EXCEPT
			SELECT
				gm.umGroupId
			FROM UMGroups g WITH(NOLOCK)
				INNER JOIN UMDSGroupMaps gm WITH(NOLOCK) ON
					gm.umDSGroupId = g.id
				INNER JOIN UMDSProviders p WITH(NOLOCK) ON
					p.id = g.umDSProviderId
					AND p.serviceType IN (2, 5)		-- UMDS_PROVIDER_ACTIVE_DIR, UMDS_PROVIDER_ORGANIZATIONS
			WHERE
				(p.domainName + N'\' + g.name) = @compValue
	END
	ELSE IF (@opType = 3)
	BEGIN
		INSERT INTO @Groups(groupId)
			SELECT
				g.id
			FROM UMGroups g WITH(NOLOCK)
				INNER JOIN UMDSProviders p WITH(NOLOCK) ON
					p.id = g.umdsProviderId
					AND g.umdsProviderId <> 0		-- no local provider
					AND p.serviceType IN (2, 5)		-- UMDS_PROVIDER_ACTIVE_DIR, UMDS_PROVIDER_ORGANIZATIONS
			WHERE
				(p.domainName + N'\' + g.name) LIKE @compValue
			UNION
			SELECT
				g.id
			FROM UMGroups g WITH(NOLOCK)
				INNER JOIN UMDSGroupMaps gm WITH(NOLOCK) ON
					gm.umDSGroupId = g.id
				INNER JOIN UMDSGroups dg WITH(NOLOCK) ON
					dg.id = gm.umDSGroupId
					AND dg.umDSProviderId <> 0		-- no local provider
				INNER JOIN UMDSProviders p WITH(NOLOCK) ON
					p.id = dg.umDSProviderId
					AND p.serviceType IN (2, 5)		-- UMDS_PROVIDER_ACTIVE_DIR, UMDS_PROVIDER_ORGANIZATIONS
			WHERE
				(p.domainName + N'\' + dg.name) LIKE @compValue
	END
	ELSE IF (@opType = 4)
	BEGIN
		INSERT INTO @Groups(groupId)
			SELECT
				g.id
			FROM UMGroups g WITH(NOLOCK)
				INNER JOIN UMDSProviders p WITH(NOLOCK) ON
					p.id = g.umdsProviderId
					AND g.umdsProviderId <> 0		-- no local provider
					AND p.serviceType IN (2, 5)		-- UMDS_PROVIDER_ACTIVE_DIR, UMDS_PROVIDER_ORGANIZATIONS
			WHERE
				(p.domainName + N'\' + g.name) NOT LIKE @compValue
			UNION
			SELECT
				g.id
			FROM UMGroups g WITH(NOLOCK)
				INNER JOIN UMDSGroupMaps gm WITH(NOLOCK) ON
					gm.umgroupId = g.id
				INNER JOIN UMDSGroups dg WITH(NOLOCK) ON
					dg.id = gm.umDSGroupId
					AND dg.umDSProviderId <> 0		-- no local provider
				INNER JOIN UMDSProviders p WITH(NOLOCK) ON
					p.id = dg.umDSProviderId
					AND p.serviceType IN (2, 5)		-- UMDS_PROVIDER_ACTIVE_DIR, UMDS_PROVIDER_ORGANIZATIONS
			WHERE
				(p.domainName + N'\' + dg.name) NOT LIKE @compValue
	END
	IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN @Groups g ON a.userOrGroupId = g.groupId AND a.isUser = 0 WHERE a.includeAll = 1 AND a.entityType1 IN (3, 28))	-- includeAll=1 CLIENT_ENTITY, CLIENT_GROUP_ENTITY
		OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN @Groups g ON a.userOrGroupId = g.groupId AND a.isUser = 0 AND a.entityType1 = 1 AND a.entityId1 = 2) 		-- CommCell Level
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- All clients
			INSERT INTO @clientIds
				SELECT
					id clientId
				FROM App_Client c WITH(NOLOCK)
				WHERE
					c.id > 1
		END
		ELSE
		BEGIN
			-- Given client
			INSERT INTO @clientIds
				SELECT
					id clientId
				FROM App_Client c WITH(NOLOCK)
				WHERE
					c.id = @inClientId
		END
	END
	ELSE
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- All clients
			INSERT INTO @clientIds
				SELECT
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Groups g ON
						a.entityType1 = 3			-- CLIENT_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
				WHERE
					a.entityId1 > 1
				UNION
				SELECT
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Groups g ON
						o.entityType = 3			-- CLIENT_ENTITY
						AND o.isUser = 0
						AND g.groupId = o.userOrGroupId
				WHERE
					o.entityId > 1
				UNION
				SELECT
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Groups g ON
						a.entityType1 = 28		-- CLIENT_GROUP_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
				WHERE
					a.entityId1 > 1
				UNION
				SELECT
					cga.clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Groups g ON
						g.groupId= o.userOrGroupId
						AND o.isUser = 0
						AND o.entityType = 28		-- CLIENT_GROUP_ENTITY
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = o.entityId
				WHERE
					cga.clientId > 1
		END
		ELSE
		BEGIN
			-- Given client
			INSERT INTO @clientIds
				SELECT
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Groups g ON
						a.entityType1 = 3			-- CLIENT_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
				WHERE
					a.entityId1 = @inClientId
				UNION
				SELECT
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Groups g ON
						o.entityType = 3			-- CLIENT_ENTITY
						AND o.isUser = 0
						AND g.groupId = o.userOrGroupId
				WHERE
					o.entityId = @inClientId
				UNION
				SELECT
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Groups g ON
						a.entityType1 = 28		-- CLIENT_GROUP_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
				WHERE
					a.entityId1 = @inClientId
				UNION
				SELECT
					cga.clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Groups g ON
						g.groupId= o.userOrGroupId
						AND o.isUser = 0
						AND o.entityType = 28		-- CLIENT_GROUP_ENTITY
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = o.entityId
				WHERE
					cga.clientId = @inClientId
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2UserGroupClientAssociations]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2UserGroupClientAssociations' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2UserGroupClientAssociations',  '1.1.2.5', 'scgV2UserGroupClientAssociations', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
