

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2UserClientAssociations.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2UserClientAssociations'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2UserClientAssociations]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2UserClientAssociations]
  delete from GXDBVersions where name = 'scgV2UserClientAssociations' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2UserClientAssociations(@operator VARCHAR(16), @compValue NVARCHAR(256), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	-- Is input comparsion value a login or email address - Check for '@' existence?
	DECLARE @isEmail	TINYINT = 0
	IF (CHARINDEX(N'@', @compValue, 0) > 0)
	BEGIN
		SET @isEmail = 1
	END
	DECLARE @Users TABLE (
		userId		INT PRIMARY KEY
	)
	IF (@isEmail = 1)
	BEGIN
		-- Email Address
		IF (@opType = 1)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND (
						u.email = @compValue
						OR u.login = @compValue
					)
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND (
						u.email <> @compValue
						AND u.login <> @compValue
					)
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND (
						u.email LIKE @compValue
						OR u.login LIKE @compValue
					)
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND (
						u.email NOT LIKE @compValue
						AND u.login NOT LIKE @compValue
					)
		END
	END
	ELSE
	BEGIN
		-- Login
		IF (@opType = 1)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND u.login = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND u.login <> @compValue
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND u.login LIKE @compValue
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @Users(userId)
				SELECT DISTINCT
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						p.id = u.umDSProviderId
						AND p.serviceType IN (2, 5)
				WHERE
					(u.flags & 1) <> 0
					AND u.login NOT LIKE @compValue
		END
	END
	IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN @Users u ON a.userOrGroupId = u.userId AND a.isUser = 1 WHERE a.includeAll = 1 AND a.entityType1 IN (3, 28))	-- includeAll=1 CLIENT_ENTITY, CLIENT_GROUP_ENTITY
		OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON a.entityType1 IN (3, 28) AND a.userOrGroupId = gm.umgroupId AND a.isUser = 0 AND a.includeAll = 1 INNER JOIN UMUserGroup ug WITH (NOLOCK) ON gm.umDSgroupId = ug.groupId INNER JOIN @Users u ON u.userId = ug.userId)
		OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN UMUserGroup ug WITH(NOLOCK) ON a.userOrGroupId = ug.groupId AND a.isUser = 0 AND a.entityType1 IN (3,28) AND a.includeAll = 1  INNER JOIN @Users u ON u.userId = ug.userId)
		OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN @Users u ON a.userOrGroupId = u.userId AND a.isUser = 1 AND a.entityType1 = 1 AND a.entityId1 = 2) 		-- CommCell Level
		OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN UMUserGroup ug WITH(NOLOCK) ON a.userOrGroupId = ug.groupId AND a.isUser = 0 AND a.entityType1 = 1 AND a.entityId1 = 2 INNER JOIN @Users u ON u.userId = ug.userId)
		OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations a WITH(NOLOCK) INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON a.entityType1 = 1 AND a.entityId1 = 2 AND a.userOrGroupId = gm.umgroupId AND a.isUser = 0 INNER JOIN UMUserGroup ug WITH (NOLOCK) ON gm.umDSgroupId = ug.groupId INNER JOIN @Users u ON u.userId = ug.userId)
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- All Clients
			INSERT INTO @clientIds
				SELECT
					id clientId
				FROM App_Client c WITH(NOLOCK)
				WHERE
					c.id > 1
		END
		ELSE
		BEGIN
			-- Given client
			INSERT INTO @clientIds
				SELECT
					id clientId
				FROM App_Client c WITH(NOLOCK)
				WHERE
					c.id = @inClientId
		END
	END
	ELSE
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- All Clients
			INSERT INTO @clientIds
				SELECT --1
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Users u ON
						a.entityType1 = 3		-- CLIENT_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
				WHERE
					a.entityId1 > 1
				UNION
				SELECT --2
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						a.entityType1 = 3		-- CLIENT_ENTITY
						AND a.isUser = 0
						AND ug.groupId = a.userOrGroupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					a.entityId1 > 1
				UNION
				SELECT --3
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Users u ON
						o.entityType = 3		-- CLIENT_ENTITY
						AND o.isUser = 1
						AND o.userOrGroupId = u.userId
				WHERE
					o.entityId > 1
				UNION
				SELECT --4
					o.entityId clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						o.entityType = 3		-- CLIENT_ENTITY
						AND o.isUser = 0
						AND ug.groupId = o.userOrGroupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					o.entityId > 1
				UNION
				SELECT --5
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Users u ON
						a.entityType1 = 28		-- CLIENT_GROUP_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						a.entityId1 = cga.clientGroupId
				WHERE
					cga.clientId > 1
				UNION
				SELECT --6
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						a.entityType1 = 28		-- CLIENT_GROUP_ENTITY
						AND a.isUser = 0
						AND ug.groupId = a.userOrGroupId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						a.entityId1 = cga.clientGroupId
				WHERE
					cga.clientId > 1
				UNION
				SELECT --7
					cga.clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Users u ON
						o.entityType = 28		-- CLIENT_GROUP_ENTITY
						AND o.isUser = 1
						AND o.userOrGroupId = u.userId
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						o.entityId = cga.clientGroupId
				WHERE
					cga.clientId > 1
				UNION
				SELECT --8
					cga.clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						o.entityType = 28		-- CLIENT_GROUP_ENTITY
						AND o.isUser = 0
						AND ug.groupId = o.userOrGroupId
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						o.entityId = cga.clientGroupId
				WHERE
					cga.clientId > 1
				UNION
				SELECT --9
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						a.entityType1 = 3				-- CLIENT_ENTITY
						AND a.userOrGroupId = gm.umgroupId
						AND a.isUser = 0
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					a.entityId1 > 1
				UNION
				SELECT --10
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						a.entityType1 = 28				-- CLIENT_GROUP_ENTITY
						AND a.userOrGroupId = gm.umgroupId
						AND a.isUser = 0
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
				WHERE
					cga.clientId > 1
				UNION
				SELECT --11
					o.entityId clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						o.entityType = 3				-- CLIENT_ENTITY
						AND o.userOrGroupId = gm.umgroupId
						AND o.isUser = 0
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					o.entityId > 1
				UNION
				SELECT --12
					cga.clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						o.entityType = 28				-- CLIENT_GROUP_ENTITY
						AND o.userOrGroupId = gm.umgroupId
						AND o.isUser = 0
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = o.entityId
				WHERE
					cga.clientId > 1
		END
		ELSE
		BEGIN
			-- Given client
			INSERT INTO @clientIds
				SELECT --1
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Users u ON
						a.entityType1 = 3		-- CLIENT_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
				WHERE
					a.entityId1 = @inClientId
				UNION
				SELECT --2
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						a.entityType1 = 3		-- CLIENT_ENTITY
						AND a.isUser = 0
						AND ug.groupId = a.userOrGroupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					a.entityId1 = @inClientId
				UNION
				SELECT --3
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Users u ON
						o.entityType = 3		-- CLIENT_ENTITY
						AND o.isUser = 1
						AND o.userOrGroupId = u.userId
				WHERE
					o.entityId = @inClientId
				UNION
				SELECT --4
					o.entityId clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						o.entityType = 3		-- CLIENT_ENTITY
						AND o.isUser = 0
						AND ug.groupId = o.userOrGroupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					o.entityId = @inClientId
				UNION
				SELECT --5
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN @Users u ON
						a.entityType1 = 28		-- CLIENT_GROUP_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						a.entityId1 = cga.clientGroupId
				WHERE
					cga.clientId = @inClientId
				UNION
				SELECT --6
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						a.entityType1 = 28		-- CLIENT_GROUP_ENTITY
						AND a.isUser = 0
						AND ug.groupId = a.userOrGroupId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						a.entityId1 = cga.clientGroupId
				WHERE
					cga.clientId = @inClientId
				UNION
				SELECT --7
					cga.clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN @Users u ON
						o.entityType = 28		-- CLIENT_GROUP_ENTITY
						AND o.isUser = 1
						AND o.userOrGroupId = u.userId
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						o.entityId = cga.clientGroupId
				WHERE
					cga.clientId = @inClientId
				UNION
				SELECT --8
					cga.clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMUserGroup ug WITH(NOLOCK) ON
						o.entityType = 28		-- CLIENT_GROUP_ENTITY
						AND o.isUser = 0
						AND ug.groupId = o.userOrGroupId
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						o.entityId = cga.clientGroupId
				WHERE
					cga.clientId = @inClientId
				UNION
				SELECT --9
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						a.entityType1 = 3				-- CLIENT_ENTITY
						AND a.userOrGroupId = gm.umgroupId
						AND a.isUser = 0
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					a.entityId1 = @inClientId
				UNION
				SELECT --10
					cga.clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						a.entityType1 = 28				-- CLIENT_GROUP_ENTITY
						AND a.userOrGroupId = gm.umgroupId
						AND a.isUser = 0
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
				WHERE
					cga.clientId = @inClientId
				UNION
				SELECT --11
					o.entityId clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						o.entityType = 3				-- CLIENT_ENTITY
						AND o.userOrGroupId = gm.umgroupId
						AND o.isUser = 0
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
				WHERE
					o.entityId = @inClientId
				UNION
				SELECT --12
					cga.clientId
				FROM  UMOwners o WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH (NOLOCK) ON
						o.entityType = 28				-- CLIENT_GROUP_ENTITY
						AND o.userOrGroupId = gm.umgroupId
						AND o.isUser = 0
						AND (
							@inSCGId = 0
							OR o.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN UMUserGroup ug WITH (NOLOCK) ON
						gm.umDSgroupId = ug.groupId
					INNER JOIN @Users u ON
						u.userId = ug.userId
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = o.entityId
				WHERE
					cga.clientId = @inClientId
			END
		END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2UserClientAssociations]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2UserClientAssociations' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2UserClientAssociations',  '1.1.2.5', 'scgV2UserClientAssociations', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
