

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2RestoreActivityForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2RestoreActivityForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2RestoreActivityForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2RestoreActivityForClient]
  delete from GXDBVersions where name = 'scgV2RestoreActivityForClient' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2RestoreActivityForClient(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	IF (@inClientId = 0)
	BEGIN
		-- All clients
		IF (@compValue > 0)
		BEGIN
			-- Backup Enabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND ja.appType = 0
						AND ja.opType = 5	-- CVOpType::RESTORE. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					c.id > 1
					AND (ja.action & 2) = 2
		END
		ELSE
		BEGIN
			-- Backup Disabled
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND ja.appType = 0
						AND ja.opType = 5	-- CVOpType::RESTORE. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					c.id > 1
					AND (
						ja.action IS NULL
						OR (ja.action & 2) = 0
					)
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@compValue > 0)
		BEGIN
			-- Backup Enabled
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND c.id = @inClientId
						AND ja.appType = 0
						AND ja.opType = 5	-- CVOpType::RESTORE. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					(ja.action & 2) = 2
		END
		ELSE
		BEGIN
			-- Backup Disabled
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
						c.id = ja.clientId
						AND c.id = @inClientId
						AND ja.appType = 0
						AND ja.opType = 5	-- CVOpType::RESTORE. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				WHERE
					c.id = @inClientId
					AND (
						ja.action IS NULL
						OR (ja.action & 2) = 0
					)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2RestoreActivityForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2RestoreActivityForClient' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2RestoreActivityForClient',  '1.1.2.4', 'scgV2RestoreActivityForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
