

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2MediaAgentsInGroupList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2MediaAgentsInGroupList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2MediaAgentsInGroupList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2MediaAgentsInGroupList]
  delete from GXDBVersions where name = 'scgV2MediaAgentsInGroupList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2MediaAgentsInGroupList(@operator VARCHAR(24), @compValue XML, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @ClientGroups TABLE (
		id	INT PRIMARY KEY
	)
	INSERT INTO @ClientGroups (id)
		SELECT
			cg.value('@val', 'integer')
		FROM
			@compValue.nodes('/App_SCGRuleValueList/id')	l(cg)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- no client groups nothing to do
		RETURN
	END
	-- Table to store fake MAs that are only SNAP Enabled with no associated storage library
	DECLARE @SnapMAs TABLE (
		maClientId	INT PRIMARY KEY
	)
	IF (@inClientId = 0)
	BEGIN
		-- All clients
		INSERT INTO @SnapMAs (maClientId)
			SELECT DISTINCT
				h.ClientId mediaAgentId
			FROM
				MMHost h WITH(READUNCOMMITTED)
				LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON	-- is SNAP Enabled?
					h.ClientId = cp.componentNameId
					AND cp.attrName = 'Snap Backups Enabled'	-- CV_PROP_SNAP_BACKUPS_ENABLED_NAME
					AND cp.modified = 0
				OUTER APPLY (
					SELECT TOP 1
						1 hasStorage
					FROM MMLibraryController d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
					UNION
					SELECT TOP 1
						1 hasStorage
					FROM MMDrivepool d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
				) s
			WHERE
				cp.attrVal IS NOT NULL
				AND cp.attrVal = '1'		-- SNAP is enabled for MA
				AND s.hasStorage IS NULL	-- has no storage libraries - fake MA add to list
				AND h.ClientId > 1
	END
	ELSE
	BEGIN
		-- Given client
		INSERT INTO @SnapMAs (maClientId)
			SELECT DISTINCT
				h.ClientId mediaAgentId
			FROM
				MMHost h WITH(READUNCOMMITTED)
				LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON	-- is SNAP Enabled?
					h.ClientId = cp.componentNameId
					AND h.ClientId = @inClientId
					AND cp.attrName = 'Snap Backups Enabled'	-- CV_PROP_SNAP_BACKUPS_ENABLED_NAME
					AND cp.modified = 0
				OUTER APPLY (
					SELECT TOP 1
						1 hasStorage
					FROM MMLibraryController d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
						AND h.ClientId = @inClientId
					UNION
					SELECT TOP 1
						1 hasStorage
					FROM MMDrivepool d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
						AND h.ClientId = @inClientId
				) s
			WHERE
				cp.attrVal IS NOT NULL
				AND cp.attrVal = '1'		-- SNAP is enabled for MA
				AND s.hasStorage IS NULL	-- has no storage libraries - fake MA add to list
				AND h.ClientId = @inClientId
	END
	IF (@inClientId = 0)
	BEGIN
		-- All clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						cga.clientId = c.id
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id > 1
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					C.id
				FROM APP_Client C WITH (READUNCOMMITTED)
				WHERE
					C.id > 1
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						cga.clientId = c.id
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id > 1
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		--ELSE empty table returned
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
						AND c.id = @inClientId
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						cga.clientId = c.id
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					C.id
				FROM APP_Client C WITH (READUNCOMMITTED)
				WHERE
					C.id = @inClientId
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
						AND c.id = @inClientId
					INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED) ON
						cga.clientId = c.id
					INNER JOIN @ClientGroups cg ON
						cg.id = cga.clientGroupId
				WHERE
					c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		--ELSE empty table returned
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2MediaAgentsInGroupList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2MediaAgentsInGroupList' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2MediaAgentsInGroupList',  '1.1.2.4', 'scgV2MediaAgentsInGroupList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
