

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2MediaAgentsInGroup.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2MediaAgentsInGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2MediaAgentsInGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2MediaAgentsInGroup]
  delete from GXDBVersions where name = 'scgV2MediaAgentsInGroup' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2MediaAgentsInGroup(@operator VARCHAR(24), @compValue NVARCHAR(1024), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	-- Table to store fake MAs that are only SNAP Enabled with no associated storage library
	DECLARE @SnapMAs TABLE (
		maClientId	INT PRIMARY KEY
	)
	IF (@inClientId = 0)
	BEGIN
		-- All clients
		INSERT INTO @SnapMAs(maClientId)
			SELECT DISTINCT
				h.ClientId mediaAgentId
			FROM
				MMHost h WITH(READUNCOMMITTED)
				LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON	-- is SNAP Enabled?
					h.ClientId = cp.componentNameId
					AND cp.attrName = 'Snap Backups Enabled'		-- CV_PROP_SNAP_BACKUPS_ENABLED_NAME
					AND cp.modified = 0
				OUTER APPLY (
					SELECT TOP 1
						1 hasStorage
					FROM MMLibraryController d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
					UNION
					SELECT TOP 1
						1 hasStorage
					FROM MMDrivepool d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
				) s
			WHERE
				cp.attrVal IS NOT NULL
				AND cp.attrVal = '1'		-- SNAP is enabled for MA
				AND s.hasStorage IS NULL	-- has no storage libraries - fake MA add to list
				AND h.ClientId > 1
	END
	ELSE
	BEGIN
		-- Given clients
		INSERT INTO @SnapMAs(maClientId)
			SELECT DISTINCT
				h.ClientId mediaAgentId
			FROM
				MMHost h WITH(READUNCOMMITTED)
				LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON	-- is SNAP Enabled?
					h.ClientId = cp.componentNameId
					AND h.ClientId = @inClientId
					AND cp.attrName = 'Snap Backups Enabled'		-- CV_PROP_SNAP_BACKUPS_ENABLED_NAME
					AND cp.modified = 0
				OUTER APPLY (
					SELECT TOP 1
						1 hasStorage
					FROM MMLibraryController d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
						AND h.ClientId = @inClientId
					UNION
					SELECT TOP 1
						1 hasStorage
					FROM MMDrivepool d WITH(READUNCOMMITTED)
					WHERE
						h.ClientId = d.ClientId
						AND h.ClientId = @inClientId
				) s
			WHERE
				cp.attrVal IS NOT NULL
				AND cp.attrVal = '1'		-- SNAP is enabled for MA
				AND s.hasStorage IS NULL	-- has no storage libraries - fake MA add to list
				AND h.ClientId = @inClientId
	END
	IF (@inClientId = 0)
	BEGIN
		-- All clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
					) g ON
						g.clientId = c.id
				WHERE
					c.id > 1
					AND g.name = @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					C.Id
				FROM APP_Client C WITH (READUNCOMMITTED)
				WHERE
					C.id > 1
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
					) g ON
						g.clientId = c.id
				WHERE
					c.id > 1
					AND g.name = @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
					) g ON
						g.clientId = c.id
				WHERE
					c.id > 1
					AND g.name LIKE @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					C.id
				FROM APP_Client C WITH (READUNCOMMITTED)
				WHERE
					C.id > 1
				EXCEPT
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
					) g ON
						g.clientId = c.id
				WHERE
					c.id > 1
					AND g.name LIKE @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		--ELSE empty table returned
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
						AND c.id = @inClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
					) g ON
						g.clientId = c.id
				WHERE
					g.name = @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					C.Id
				FROM APP_Client C WITH (READUNCOMMITTED)
				WHERE
					C.id = @inClientId
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
						AND c.id = @inClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
								AND cga.clientId = @inClientId
					) g ON
						g.clientId = c.id
				WHERE
					g.name = @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
						AND c.id = @inClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
								AND cga.clientId = @inClientId
					) g ON
						g.clientId = c.id
				WHERE
					g.name LIKE @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					C.id
				FROM APP_Client C WITH (READUNCOMMITTED)
				WHERE
					C.id = @inClientId
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN MMHost ma WITH(READUNCOMMITTED) ON
						c.id = ma.ClientId
						AND c.id = @inClientId
					INNER JOIN (
						SELECT
							cga.clientId,
							cg.name
						FROM APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)
							INNER JOIN APP_ClientGroup cg WITH(READUNCOMMITTED) ON
								cg.id = cga.clientGroupId
								AND cga.clientId = @inClientId
					) g ON
						g.clientId = c.id
				WHERE
					g.name LIKE @compValue
					AND c.id NOT IN (SELECT maClientId FROM @SnapMAs)
		END
		--ELSE empty table returned
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2MediaAgentsInGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2MediaAgentsInGroup' AND revision = '1.1.2.8')

  insert into GXDBVersions values(5, 'scgV2MediaAgentsInGroup',  '1.1.2.8', 'scgV2MediaAgentsInGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
