

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2MediaAgentHasLuceneIndexRoles.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2MediaAgentHasLuceneIndexRoles'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2MediaAgentHasLuceneIndexRoles]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2MediaAgentHasLuceneIndexRoles]
  delete from GXDBVersions where name = 'scgV2MediaAgentHasLuceneIndexRoles' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2MediaAgentHasLuceneIndexRoles(@operator VARCHAR(24), @compValue integer, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN DM2SearchServerCoreInfo s WITH(READUNCOMMITTED) ON
						s.ClientId = c.id
					INNER JOIN DM2CloudCoreRole r WITH(READUNCOMMITTED) ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m WITH(READUNCOMMITTED) ON
						r.roleId = m.roleType
				WHERE
					m.roleType = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN DM2SearchServerCoreInfo s WITH(READUNCOMMITTED) ON
						s.ClientId = c.id
					INNER JOIN DM2CloudCoreRole r WITH(READUNCOMMITTED) ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m WITH(READUNCOMMITTED) ON
						r.roleId = m.roleType
				WHERE
					m.roleType = @compValue
		END
	END
	ELSE
	BEGIN
		-- given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN DM2SearchServerCoreInfo s WITH(READUNCOMMITTED) ON
						s.ClientId = c.id
						AND c.id = @inClientId
					INNER JOIN DM2CloudCoreRole r WITH(READUNCOMMITTED) ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m WITH(READUNCOMMITTED) ON
						r.roleId = m.roleType
				WHERE
					m.roleType = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				SELECT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN DM2SearchServerCoreInfo s WITH(READUNCOMMITTED) ON
						s.ClientId = c.id
						AND c.id = @inClientId
					INNER JOIN DM2CloudCoreRole r WITH(READUNCOMMITTED) ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m WITH(READUNCOMMITTED) ON
						r.roleId = m.roleType
				WHERE
					m.roleType = @compValue
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2MediaAgentHasLuceneIndexRoles]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2MediaAgentHasLuceneIndexRoles' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'scgV2MediaAgentHasLuceneIndexRoles',  '1.1.2.7', 'scgV2MediaAgentHasLuceneIndexRoles', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
