

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2MediaAgentHasLuceneIndexRoleList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2MediaAgentHasLuceneIndexRoleList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2MediaAgentHasLuceneIndexRoleList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2MediaAgentHasLuceneIndexRoleList]
  delete from GXDBVersions where name = 'scgV2MediaAgentHasLuceneIndexRoleList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2MediaAgentHasLuceneIndexRoleList(@operator VARCHAR(24), @compValue XML, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @Roles TABLE (
		id	INT PRIMARY KEY
	)
	INSERT INTO @Roles (id)
		SELECT
			cg.value('@val', 'integer')
		FROM
			@compValue.nodes('/App_SCGRuleValueList/id')	l(cg)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- no roles nothing to do
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM  APP_Client c
					INNER JOIN DM2SearchServerCoreInfo s ON
						s.ClientId = c.id
					INNER JOIN DM2CloudCoreRole r ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m ON
						r.roleId = m.roleType
					INNER JOIN @Roles ro ON
						ro.id = m.roleType
				WHERE
					c.id > 1
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT DISTINCT
					c.id clientId
				FROM  APP_Client c
					INNER JOIN DM2SearchServerCoreInfo s ON
						s.ClientId = c.id
					INNER JOIN DM2CloudCoreRole r ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m ON
						r.roleId = m.roleType
					INNER JOIN @Roles ro ON
						ro.id = m.roleType
				WHERE
					c.id > 1
		END
	END
	ELSE
	BEGIN
		-- given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM  APP_Client c
					INNER JOIN DM2SearchServerCoreInfo s ON
						s.ClientId = c.id
						AND c.id = @inClientId
					INNER JOIN DM2CloudCoreRole r ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m ON
						r.roleId = m.roleType
					INNER JOIN @Roles ro ON
						ro.id = m.roleType
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM  APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				SELECT
					c.id clientId
				FROM  APP_Client c
					INNER JOIN DM2SearchServerCoreInfo s ON
						s.ClientId = c.id
						AND c.id = @inClientId
					INNER JOIN DM2CloudCoreRole r ON
						s.CloudId = r.CloudId
					INNER JOIN DM2CloudRoleMaster m ON
						r.roleId = m.roleType
					INNER JOIN @Roles ro ON
						ro.id = m.roleType
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2MediaAgentHasLuceneIndexRoleList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2MediaAgentHasLuceneIndexRoleList' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2MediaAgentHasLuceneIndexRoleList',  '1.1.2.5', 'scgV2MediaAgentHasLuceneIndexRoleList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
