

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2IsPseudoClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2IsPseudoClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2IsPseudoClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2IsPseudoClients]
  delete from GXDBVersions where name = 'scgV2IsPseudoClients' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
--MR 244011
CREATE FUNCTION scgV2IsPseudoClients(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
BEGIN
	DECLARE @PseudoClients TABLE (
		clientId	INT,
		isPseudo	INT,
		 PRIMARY KEY (isPseudo, clientId)
	)
	DECLARE @pseudoStatus INT
	-- Default Pseudo Clients: CV_STATUS_ORACLE_RAC | CV_STATUS_NAS | CV_STATUS_DB2_DPF | CV_STATUS_DAG | CV_STATUS_OBJECT_SERVER | CV_STATUS_REFERENCE_COPY | CV_STATUS_SAP_HANA | CV_STATUS_MSSQLAG
	SET @pseudoStatus = (
		CAST(0x0040 AS INT) | CAST(0x0080 AS INT) | CAST(0x0200 AS INT) | CAST(0x200000 AS INT) |
		CAST(0x400000 AS INT) | CAST(0x4000000 AS INT) | CAST(0x2000000 AS INT) | CAST(0x20000000 AS INT)
	)
	DECLARE @specialFlags INT = CAST(0x02 AS INT)
	DECLARE @cgFlags INT = (CAST(0x100 AS INT) | CAST(0x200 AS INT))
	INSERT INTO @PseudoClients (clientId, isPseudo)
		SELECT DISTINCT
			c.id,
			CASE
				WHEN (c.status & @pseudoStatus) > 0 THEN 1
				WHEN (c.specialClientFlags & @specialFlags) > 0 AND lu.Cid IS NULL AND a.clientId IS NULL THEN 1
				WHEN c.simOperatingSystemId = 38 THEN 1		-- OPENVMS CLIENTS  N_CV_OS_ID_OPENVMS = 38
				WHEN cp.id IS NOT NULL THEN 1				-- DISCOVERED CLIENTS
				ELSE 0
			END
		FROM APP_Client c WITH(NOLOCK)
			LEFT OUTER JOIN SIMInstalledPackages ip WITH(NOLOCK) ON		-- pseudo clients have no packages installed
				ip.clientId = c.id
			LEFT OUTER JOIN APP_Application a WITH(NOLOCK) ON
				a.clientId = c.id
			LEFT OUTER JOIN LicUsage lu WITH(NOLOCK) ON
				lu.Cid = c.id
			LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
				cp.componentNameId = c.id
				AND cp.modified = 0
				AND cp.attrName IN (N'Virtual Server Discovered Clients', N'SharePoint Farm Client', N'Mini SRM Agent')
				AND cp.attrVal = N'1'
		WHERE
			ip.clientId IS NULL
			AND (c.status & (2|4)) = 0		-- not uninstalled or deleted
			AND c.id > 1
	-- VS PSEUDO CLIENTS
	UPDATE pc
		SET isPseudo = 1
	FROM @PseudoClients pc
		INNER JOIN APP_IDAName n WITH(NOLOCK) ON
			pc.clientId = n.clientId
		INNER JOIN APP_IdaProp p WITH(NOLOCK) ON
			p.componentNameId = n.id
			AND p.modified = 0
			AND p.attrName = N'Pseudo Apptype'
			AND p.attrVal = N'1'
	WHERE
		pc.isPseudo = 0
	--EDC CLIENTS
	UPDATE pc
		SET isPseudo = 1
	FROM @PseudoClients pc
		INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
			cga.clientId = pc.clientId
		INNER JOIN APP_ClientGroup cg WITH(NOLOCK) ON
			cg.id = cga.clientGroupId
			AND (cg.flag & @cgFlags) > 0
	WHERE
		pc.isPseudo = 0
	IF (@compValue > 0)
	BEGIN
		-- true
		-- Return Pseudo Clients
		INSERT INTO @clientIds (clientId)
			SELECT
				clientId
			FROM @PseudoClients pc
			WHERE
				pc.isPseudo = 1
	END
	ELSE
	BEGIN
		-- false
		-- Not Pseudo Clients
		INSERT INTO @clientIds (clientId)
			SELECT
				id
			FROM APP_Client c WITH(NOLOCK)
			WHERE
				c.id > 1
			EXCEPT
			SELECT
				clientId
			FROM @PseudoClients pc
				WHERE
					pc.isPseudo = 1
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2IsPseudoClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2IsPseudoClients' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'scgV2IsPseudoClients',  '1.1.2.1', 'scgV2IsPseudoClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
