

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2IsExternalUserGroupClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2IsExternalUserGroupClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2IsExternalUserGroupClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2IsExternalUserGroupClientOwner]
  delete from GXDBVersions where name = 'scgV2IsExternalUserGroupClientOwner' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2IsExternalUserGroupClientOwner(@operator VARCHAR(24), @compValue NVARCHAR(1024), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
				WHERE
					co.clientId > 1
					AND co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) = @compValue
					)
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
				WHERE
					co.clientId > 1
					AND co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) <> @compValue
					)
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
				WHERE
					co.clientId > 1
					AND co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) LIKE @compValue --ESCAPE('\')
					)
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
				WHERE
					co.clientId > 1
					AND co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) NOT LIKE @compValue --ESCAPE('\')
					)
		END
		--ELSE empty table returned
	END
	ELSE
	BEGIN
		-- Only for the given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
						AND c.id = @inClientId
				WHERE
					co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) = @compValue
					)
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
						AND c.id = @inClientId
				WHERE
					co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) <> @compValue
					)
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
						AND c.id = @inClientId
				WHERE
					co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) LIKE @compValue --ESCAPE('\')
					)
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					co.clientId
				FROM dbo.sec_getClientOwnersExpandUG co WITH(READUNCOMMITTED)
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = co.clientId
						AND c.id = @inClientId
				WHERE
					co.externalGroupId IN (
						SELECT
							g.id
						FROM UMDSgroups g WITH(READUNCOMMITTED)
							INNER JOIN UMDSProviders p WITH(READUNCOMMITTED) ON
								p.id = g.umdsProviderId
						WHERE
							(p.domainname + '\' + g.name) NOT LIKE @compValue --ESCAPE('\')
					)
		END
		--ELSE empty table returned
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2IsExternalUserGroupClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2IsExternalUserGroupClientOwner' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'scgV2IsExternalUserGroupClientOwner',  '1.1.2.7', 'scgV2IsExternalUserGroupClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
