

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2IsDeletedVMClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2IsDeletedVMClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2IsDeletedVMClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2IsDeletedVMClients]
  delete from GXDBVersions where name = 'scgV2IsDeletedVMClients' and type = 5
END
GO

 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION scgV2IsDeletedVMClients(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
 RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
--- WITH ENCRYPTION
 BEGIN
	-- Get matching VM Clients
	DECLARE @vmClients TABLE (
		clientId	INT,
		scId		INT,
		PRIMARY KEY (scId, clientId)
	)
	IF (@inClientId > 0)
	BEGIN
		INSERT INTO @vmClients (clientId, scId)
			SELECT
				c.id,
				CAST(cp2.attrVal AS INT)
			FROM APP_Client c WITH(NOLOCK)
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					c.id = cp.componentNameId
					AND cp.attrName = N'Virtual Server Discovered Clients'
					AND cp.attrval = N'1'
					AND cp.modified = 0
				INNER JOIN APP_ClientProp cp2 WITH(NOLOCK) ON
					c.id = cp2.componentNameId
					AND cp2.attrName = N'Last Backup Subclient'
					AND cp2.modified = 0
			WHERE
				c.id = @inClientId
				AND c.id <> 1
	END
	ELSE
	BEGIN
		-- All Clients
		INSERT INTO @vmClients (clientId, scId)
			SELECT
				c.id,
				CAST(cp2.attrVal AS INT)
			FROM APP_Client c WITH(NOLOCK)
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					c.id = cp.componentNameId
					AND cp.attrName = N'Virtual Server Discovered Clients'
					AND cp.attrval = N'1'
					AND cp.modified = 0
				INNER JOIN APP_ClientProp cp2 WITH(NOLOCK) ON
					c.id = cp2.componentNameId
					AND cp2.attrName = N'Last Backup Subclient'
					AND cp2.modified = 0
			WHERE
				c.id <> 1
	END
	IF (@compValue > 0)
	BEGIN
		-- true
		INSERT INTO  @clientIds (clientId)
			SELECT
				c.clientId
			FROM @vmClients c
				LEFT OUTER JOIN APP_application a WITH(NOLOCK) ON
					a.id = c.scId
				WHERE
					a.id IS NULL
	END
	ELSE
	BEGIN
		-- false
		INSERT INTO  @clientIds (clientId)
			SELECT
				c.clientId
			FROM @vmClients c
				LEFT OUTER JOIN APP_application a WITH(NOLOCK) ON
					a.id = c.scId
				WHERE
					a.id IS NOT NULL
	END
 	RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2IsDeletedVMClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2IsDeletedVMClients' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'scgV2IsDeletedVMClients',  '1.1.2.1', 'scgV2IsDeletedVMClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
