

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2IsClientVersionSameAsCsVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2IsClientVersionSameAsCsVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2IsClientVersionSameAsCsVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2IsClientVersionSameAsCsVersion]
  delete from GXDBVersions where name = 'scgV2IsClientVersionSameAsCsVersion' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2IsClientVersionSameAsCsVersion(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	-- Get CS Version data
	DECLARE @CsHighestSP		INT = 0
	DECLARE @CsSpMinorVersion	INT = 0
	DECLARE @CsReleaseId		INT = 0
	SELECT
	--	c.id csClientId,
		@CsReleaseId = c.releaseId,
		@CsHighestSP = ip.HighestSP,
		@CsSpMinorVersion = ip.SpMinorVersion
	FROM APP_Client c WITH(READUNCOMMITTED)
		INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
			ip.ClientId = c.id
			AND ip.simPackageID = 1
	WHERE
		c.id = ISNULL((SELECT CAST(cp.attrVal AS INT) FROM APP_ClientProp cp WITH(READUNCOMMITTED) WHERE cp.attrName = 'CS Active Physical Node' AND cp.componentnameid = 2 AND cp.modified = 0), 2)
	IF (@compValue > 0)
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- true clients have same version as CS
			INSERT INTO @clientIds
				SELECT
					ac.clientId
				FROM
					(
						SELECT	-- active clientId mapping
							ic.id clientId,
							ic.releaseId,
							CASE
								WHEN cp.attrVal IS NULL THEN ic.id
								ELSE CAST(cp.attrVal AS INT)
							END activeClientId
						FROM APP_Client ic WITH(READUNCOMMITTED)
							LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
								cp.componentnameid = ic.id
								AND cp.modified = 0
								AND cp.attrName = 'CS Active Physical Node'
					) ac
					INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
						ip.ClientId = ac.activeClientId
						AND ip.simPackageID IN (1, 1002)
				WHERE
					ac.clientId > 1
					AND ac.releaseId = @CsReleaseId
					AND ip.HighestSP = @CsHighestSP
					AND ip.SpMinorVersion = @CsSpMinorVersion
		END
		ELSE
		BEGIN
			-- true clients have same version as CS
			INSERT INTO @clientIds
				SELECT
					ac.clientId
				FROM
					(
						SELECT	-- active clientId mapping
							ic.id clientId,
							ic.releaseId,
							CASE
								WHEN cp.attrVal IS NULL THEN ic.id
								ELSE CAST(cp.attrVal AS INT)
							END activeClientId
						FROM APP_Client ic WITH(READUNCOMMITTED)
							LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
								cp.componentnameid = ic.id
								AND cp.modified = 0
								AND cp.attrName = 'CS Active Physical Node'
						WHERE
							ic.id = @inClientId
					) ac
					INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
						ip.ClientId = ac.activeClientId
						AND ip.simPackageID IN (1, 1002)
				WHERE
					ac.releaseId = @CsReleaseId
					AND ip.HighestSP = @CsHighestSP
					AND ip.SpMinorVersion = @CsSpMinorVersion
		END
	END
	ELSE
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- false clients do not have the same version as CS
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				(
					SELECT
						ac.clientId
					FROM
						(
							SELECT	-- active clientId mapping
								ic.id clientId,
								ic.releaseId,
								CASE
									WHEN cp.attrVal IS NULL THEN ic.id
									ELSE CAST(cp.attrVal AS INT)
								END activeClientId
							FROM APP_Client ic WITH(READUNCOMMITTED)
								LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
									cp.componentnameid = ic.id
									AND cp.modified = 0
									AND cp.attrName = 'CS Active Physical Node'
						) ac
						INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
							ip.ClientId = ac.activeClientId
							AND ip.simPackageID IN (1, 1002)
					WHERE
						ac.clientId > 1
						AND ac.releaseId = @CsReleaseId
						AND ip.HighestSP = @CsHighestSP
						AND ip.SpMinorVersion = @CsSpMinorVersion
				)
		END
		ELSE
		BEGIN
			-- false clients do not have the same version as CS
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				(
					SELECT
						ac.clientId
					FROM
						(
							SELECT	-- active clientId mapping
								ic.id clientId,
								ic.releaseId,
								CASE
									WHEN cp.attrVal IS NULL THEN ic.id
									ELSE CAST(cp.attrVal AS INT)
								END activeClientId
							FROM APP_Client ic WITH(READUNCOMMITTED)
								LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
									cp.componentnameid = ic.id
									AND cp.modified = 0
									AND cp.attrName = 'CS Active Physical Node'
							WHERE
								ic.id = @inClientId
						) ac
						INNER JOIN simInstalledPackages ip WITH(READUNCOMMITTED) ON
							ip.ClientId = ac.activeClientId
							AND ip.simPackageID IN (1, 1002)
					WHERE
						ac.releaseId = @CsReleaseId
						AND ip.HighestSP = @CsHighestSP
						AND ip.SpMinorVersion = @CsSpMinorVersion
				)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2IsClientVersionSameAsCsVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2IsClientVersionSameAsCsVersion' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2IsClientVersionSameAsCsVersion',  '1.1.2.4', 'scgV2IsClientVersionSameAsCsVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
