

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2IsClientUsingIndexingV1.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2IsClientUsingIndexingV1'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2IsClientUsingIndexingV1]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2IsClientUsingIndexingV1]
  delete from GXDBVersions where name = 'scgV2IsClientUsingIndexingV1' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2IsClientUsingIndexingV1(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
BEGIN
	IF (@compValue > 0)
	BEGIN
		-- true
		IF (@inClientId = 0)
		BEGIN
			INSERT INTO  @clientIds (clientId)
				SELECT DISTINCT
					c.id
				FROM APP_Client c WITH(NOLOCK)
					LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName LIKE N'IndexingV2%'
				WHERE
					c.id <> 1
					AND (
						cp.id IS NULL			-- IndexingV2 does not exist, means using V1
						OR cp.attrVal = N'0'	-- Not using V2
					)
		END
		ELSE
		BEGIN
			INSERT INTO  @clientIds (clientId)
				SELECT DISTINCT
					c.id
				FROM APP_Client c WITH(NOLOCK)
					LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName LIKE N'IndexingV2%'
				WHERE
					c.id <> 1
					AND (
						cp.id IS NULL			-- IndexingV2 does not exist, means using V1
						OR cp.attrVal = N'0'	-- Not using V2
					)
					AND c.id = @inClientId
		END
	END
	ELSE
	BEGIN
		-- false
		IF (@inClientId = 0)
		BEGIN
			INSERT INTO  @clientIds (clientId)
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE c.id <> 1
				EXCEPT
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
					LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName LIKE N'IndexingV2%'
				WHERE
					c.id <> 1
					AND (
						cp.id IS NULL			-- IndexingV2 does not exist, means using V1
						OR cp.attrVal = N'0'	-- Not using V2
					)
		END
		ELSE
		BEGIN
			INSERT INTO  @clientIds (clientId)
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE c.id = @inClientId
				EXCEPT
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
					LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName LIKE N'IndexingV2%'
				WHERE
					c.id = @inClientId
					AND (
						cp.id IS NULL			-- IndexingV2 does not exist, means using V1
						OR cp.attrVal = N'0'	-- Not using V2
					)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2IsClientUsingIndexingV1]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2IsClientUsingIndexingV1' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'scgV2IsClientUsingIndexingV1',  '1.1.2.2', 'scgV2IsClientUsingIndexingV1', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
