

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2IntellisnapClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2IntellisnapClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2IntellisnapClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2IntellisnapClients]
  delete from GXDBVersions where name = 'scgV2IntellisnapClients' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2IntellisnapClients(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	IF (@compValue > 0)
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- true SnapBackup clients
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.attrName = N'Snap Backups Enabled'
						AND cp.modified = 0
				WHERE
					c.id > 1
					AND cp.attrVal = N'1'
				UNION
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
					INNER JOIN SMVolume v WITH(READUNCOMMITTED) ON
						v.AppId = a.id
						AND v.PruneFlags = 1
				WHERE
					c.id > 1
		END
		ELSE
		BEGIN
			-- true SnapBackup clients
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.attrName = N'Snap Backups Enabled'
						AND cp.modified = 0
						AND c.id = @inClientId
				WHERE
					cp.attrVal = N'1'
				UNION
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND c.id = @inClientId
					INNER JOIN SMVolume v WITH(READUNCOMMITTED) ON
						v.AppId = a.id
						AND v.PruneFlags = 1
		END
	END
	ELSE
	BEGIN
		IF (@inClientId = 0)
		BEGIN
			-- false not SnapBackup clients
			INSERT INTO @clientIds
				SELECT	-- has only inactive client owners with the ones below with some active owners removed
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				(
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.attrName = N'Snap Backups Enabled'
							AND cp.modified = 0
					WHERE
						c.id > 1
						AND cp.attrVal = N'1'
					UNION
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
							a.clientId = c.id
						INNER JOIN SMVolume v WITH(READUNCOMMITTED) ON
							v.AppId = a.id
							AND v.PruneFlags = 1
					WHERE
						c.id > 1
				)
		END
		ELSE
		BEGIN
			-- false not SnapBackup clients
			INSERT INTO @clientIds
				SELECT	-- has only inactive client owners with the ones below with some active owners removed
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id  = @inClientId
				EXCEPT
				(
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.attrName = N'Snap Backups Enabled'
							AND cp.modified = 0
							AND c.id = @inClientId
					WHERE
						cp.attrVal = N'1'
					UNION
					SELECT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
							a.clientId = c.id
							AND c.id = @inClientId
						INNER JOIN SMVolume v WITH(READUNCOMMITTED) ON
							v.AppId = a.id
							AND v.PruneFlags = 1
				)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2IntellisnapClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2IntellisnapClients' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2IntellisnapClients',  '1.1.2.4', 'scgV2IntellisnapClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
