

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2InactiveADUsersAsClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2InactiveADUsersAsClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2InactiveADUsersAsClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2InactiveADUsersAsClientOwner]
  delete from GXDBVersions where name = 'scgV2InactiveADUsersAsClientOwner' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2InactiveADUsersAsClientOwner(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@compValue = 0)
		BEGIN
			-- false has active client owners
			INSERT INTO @clientIds
				SELECT	-- has active client owners
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
						o.entitytype = 3
						AND o.entityId = c.id
						AND o.isUSer = 1
						AND o.userOrGroupId IN (SELECT u.id FROM UMusers u WITH(READUNCOMMITTED) WHERE (u.flags & 4) = 0 OR u.umdsPRoviderID = 0)
				WHERE
					c.id > 1
				UNION
				(
					SELECT	-- all clients except those identified below
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
					EXCEPT
					SELECT	-- has inactive client owners
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
						o.entitytype = 3
						AND o.entityId = c.id
						AND o.isUSer = 1
						AND o.userOrGroupId IN (SELECT u.id FROM UMusers  u WITH(READUNCOMMITTED) WHERE (u.flags & 4) <> 0 AND u.umdsPRoviderID <> 0)
					WHERE
						c.id > 1
				)
		END
		ELSE
		BEGIN
			-- true has only inactive client owners
			INSERT INTO @clientIds
				SELECT	-- has only inactive client owners with the ones below with some active owners removed
					c.id
				FROM APP_Client c WITH(READUNCOMMITTED)
				INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
					o.entitytype = 3
					AND o.entityId = c.id
					AND o.isUSer = 1
					AND o.userOrGroupId IN (SELECT u.id FROM UMusers  u WITH(READUNCOMMITTED) WHERE (u.flags & 4) <> 0 AND u.umdsPRoviderID <> 0)
				WHERE
					c.id > 1
				EXCEPT
				SELECT	-- has active client owners
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
						o.entitytype = 3
						AND o.entityId = c.id
						AND o.isUSer = 1
						AND o.userOrGroupId IN (SELECT u.id FROM UMusers u WITH(READUNCOMMITTED) WHERE (u.flags & 4) = 0 OR u.umdsPRoviderID = 0)
				WHERE
					c.id > 1
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@compValue = 0)
		BEGIN
			-- false has active client owners
			INSERT INTO @clientIds
				SELECT	-- has active client owners
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
						o.entitytype = 3
						AND o.entityId = c.id
						AND o.isUSer = 1
						AND o.userOrGroupId IN (SELECT u.id FROM UMusers u WITH(READUNCOMMITTED) WHERE (u.flags & 4) = 0 OR u.umdsPRoviderID = 0)
						AND c.id = @inClientId
				UNION
				(
					SELECT	-- all clients except those identified below
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = @inClientId
					EXCEPT
					SELECT	-- has inactive client owners
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
						o.entitytype = 3
						AND o.entityId = c.id
						AND o.isUSer = 1
						AND o.userOrGroupId IN (SELECT u.id FROM UMusers  u WITH(READUNCOMMITTED) WHERE (u.flags & 4) <> 0 AND u.umdsPRoviderID <> 0)
						AND c.id = @inClientId
				)
		END
		ELSE
		BEGIN
			-- true has only inactive client owners
			INSERT INTO @clientIds
				SELECT	-- has only inactive client owners with the ones below with some active owners removed
					c.id
				FROM APP_Client c WITH(READUNCOMMITTED)
				INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
					o.entitytype = 3
					AND o.entityId = c.id
					AND o.isUSer = 1
					AND o.userOrGroupId IN (SELECT u.id FROM UMusers  u WITH(READUNCOMMITTED) WHERE (u.flags & 4) <> 0 AND u.umdsPRoviderID <> 0)
					AND c.id = @inClientId
				EXCEPT
				SELECT	-- has active client owners
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN UMOwners o WITH(READUNCOMMITTED) ON
						o.entitytype = 3
						AND o.entityId = c.id
						AND o.isUSer = 1
						AND o.userOrGroupId IN (SELECT u.id FROM UMusers u WITH(READUNCOMMITTED) WHERE (u.flags & 4) = 0 OR u.umdsPRoviderID = 0)
						AND c.id = @inClientId
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2InactiveADUsersAsClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2InactiveADUsersAsClientOwner' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2InactiveADUsersAsClientOwner',  '1.1.2.5', 'scgV2InactiveADUsersAsClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
