

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetdaysSinceLastFullSynthetic.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetdaysSinceLastFullSynthetic'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetdaysSinceLastFullSynthetic]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetdaysSinceLastFullSynthetic]
  delete from GXDBVersions where name = 'scgV2GetdaysSinceLastFullSynthetic' and type = 5
END
GO

CREATE FUNCTION scgV2GetdaysSinceLastFullSynthetic (@operator VARCHAR(24), @compValue INT, @secCompValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
  							WHEN '=' THEN 1
  							WHEN '!=' THEN 2
  							WHEN '<>' THEN 2
  							WHEN '>' THEN 3
  							WHEN '>=' THEN 4
  							WHEN '<' THEN 5
  							WHEN '<=' THEN 6
  							WHEN 'BETWEEN' THEN 7
  							WHEN 'NOT BETWEEN' THEN 8
  							ELSE 0
  						END
	IF (@opType = 0)
	BEGIN
  		RETURN
	END
	DECLARE @nowUTC			    datetime =GetUTCDate()
	DECLARE @now				int = dbo.GetUnixTime(@nowUTC)
	DECLARE @sec1				BIGINT = (CAST(@compValue AS BIGINT) * 86400)		-- convert days to seconds
	IF (@now < @sec1)
	BEGIN
  		RETURN	-- inputted days too large to proceess against current time
	END
	DECLARE @day1				INT = 0
	DECLARE @day2				INT = 0
	IF (@secCompValue IS NOT NULL)
	BEGIN
  		DECLARE @sec2	BIGINT = (CAST(@secCompValue AS BIGINT) * 86400)	-- convert days to seconds
  		IF (@now < @sec2)
  		BEGIN
  			RETURN	-- inputted days too large to proceess against current time
  		END
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			--Assumption taken synthetic is present
			INSERT INTO @clientIds
				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount = @compValue
		END
		ELSE IF (@opType = 2) --<>
		BEGIN
			INSERT INTO @clientIds			--List all subclient who have no synthetic ever + those that match criteria
				SELECT DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK) INNER JOIN APP_Client        AS CL   WITH (NOLOCK) ON SC.clientId = CL.id
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
				SELECT clientid
				FROM
					(SELECT               a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount =@compValue
		END
		ELSE IF (@opType = 3)
		BEGIN
			--Assumption taken synthetic is present
			INSERT INTO		@clientIds
  				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >@compValue
		END
		ELSE IF (@opType = 4)
		BEGIN
			--Assumption taken synthetic is present
			INSERT INTO		@clientIds
  				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >=@compValue
		END
		ELSE IF (@opType = 5) --<
		BEGIN
			INSERT INTO @clientIds
				SELECT  DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK) INNER JOIN APP_Client        AS CL   WITH (NOLOCK) ON SC.clientId = CL.id
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
				SELECT clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >@compValue
		END
		ELSE IF (@opType = 6)
		BEGIN
  			INSERT INTO @clientIds
				SELECT  DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK) INNER JOIN APP_Client        AS CL   WITH (NOLOCK) ON SC.clientId = CL.id
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
				SELECT clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >=@compValue
		END
		ELSE IF (@opType = 7)
		BEGIN
  			IF (@compValue < @secCompValue)
  			BEGIN
  				SET @day1 = @compValue
  				SET @day2 = @secCompValue
  			END
  			ELSE
  			BEGIN
  				SET @day1 = @secCompValue
  				SET @day2 = @compValue
  			END
  			INSERT INTO @clientIds
  				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount BETWEEN @day1 and @day2
		END
		ELSE IF (@opType = 8)
		BEGIN
  			IF (@compValue < @secCompValue)
  			BEGIN
  				SET @day1 = @compValue
  				SET @day2 = @secCompValue
  			END
  			ELSE
  			BEGIN
  				SET @day1 = @secCompValue
  				SET @day2 = @compValue
  			END
			INSERT INTO @clientIds
				SELECT  DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK) INNER JOIN APP_Client        AS CL   WITH (NOLOCK) ON SC.clientId = CL.id
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
  				SELECT clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON c.id = a.clientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount BETWEEN @day1 and @day2
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			--Assumption taken synthetic is present
			INSERT INTO @clientIds
				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount = @compValue
		END
		ELSE IF (@opType = 2) --<>
		BEGIN
			INSERT INTO @clientIds			--List all subclient who have no synthetic ever + those that match criteria
				SELECT  DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK)
				INNER JOIN APP_Client AS CL   WITH (NOLOCK) ON
					SC.clientId = CL.id
					AND CL.id = @inClientId
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
				SELECT clientid
				FROM
					(SELECT               a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount =@compValue
		END
		ELSE IF (@opType = 3)
		BEGIN
			--Assumption taken synthetic is present
			INSERT INTO		@clientIds
  				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >@compValue
		END
		ELSE IF (@opType = 4)
		BEGIN
			--Assumption taken synthetic is present
			INSERT INTO		@clientIds
  				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >=@compValue
		END
		ELSE IF (@opType = 5) --<
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK)
				INNER JOIN APP_Client AS CL   WITH (NOLOCK) ON
					SC.clientId = CL.id
					AND CL.id = @inClientId
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
				SELECT clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >@compValue
		END
		ELSE IF (@opType = 6)
		BEGIN
  			INSERT INTO @clientIds
				SELECT  DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK)
				INNER JOIN APP_Client AS CL   WITH (NOLOCK) ON
					SC.clientId = CL.id
					AND CL.id = @inClientId
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
				SELECT clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount >=@compValue
		END
		ELSE IF (@opType = 7)
		BEGIN
  			IF (@compValue < @secCompValue)
  			BEGIN
  				SET @day1 = @compValue
  				SET @day2 = @secCompValue
  			END
  			ELSE
  			BEGIN
  				SET @day1 = @secCompValue
  				SET @day2 = @compValue
  			END
  			INSERT INTO @clientIds
  				SELECT DISTINCT
					clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount BETWEEN @day1 and @day2
		END
		ELSE IF (@opType = 8)
		BEGIN
  			IF (@compValue < @secCompValue)
  			BEGIN
  				SET @day1 = @compValue
  				SET @day2 = @secCompValue
  			END
  			ELSE
  			BEGIN
  				SET @day1 = @secCompValue
  				SET @day2 = @compValue
  			END
			INSERT INTO @clientIds
				SELECT  DISTINCT
					Sc.clientId
				FROM    APP_Application AS SC WITH (NOLOCK)
				INNER JOIN APP_Client AS CL   WITH (NOLOCK) ON
					SC.clientId = CL.id
					AND CL.id = @inClientId
				WHERE
											sc.appTypeId in ( select appTypeId  from GetAppTypesForAppGroup(35,0))
										AND  dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1  -- subclient is valid
										AND (SC.subclientStatus & (2|4)) = 0                               -- subclient is not deleted
										AND (CL.[status] & (2|4)) = 0                                      -- uninstalled/deleted/agentless client
				GROUP BY		 clientId
				EXCEPT
  				SELECT clientid
				FROM
					(SELECT       a.clientId,CAST(ROUND(((@now-MAX(bs.servEndDate)) / 86400.0),0) as int) as DayCount
						FROM          JMBkpStats bs WITH(NOLOCK)
						INNER JOIN    APP_Application a WITH(NOLOCK) ON bs.appId = a.id
						INNER JOIN    APP_Client c WITH(NOLOCK) ON
							c.id = a.clientId
							AND c.id = @inClientId
						WHERE         bs.status in (1, 3, 14) AND BS.bkpLevel IN (64,128,16384)
						GROUP BY      a.clientId
					)Results
				WHERE Results.DayCount BETWEEN @day1 and @day2
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetdaysSinceLastFullSynthetic]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetdaysSinceLastFullSynthetic' AND revision = '')

  insert into GXDBVersions values(5, 'scgV2GetdaysSinceLastFullSynthetic',  '', 'scgV2GetdaysSinceLastFullSynthetic', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
