

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetSubclientName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetSubclientName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetSubclientName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetSubclientName]
  delete from GXDBVersions where name = 'scgV2GetSubclientName' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetSubclientName(@operator VARCHAR(16), @compValue NVARCHAR(256), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
--	WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
				WHERE
					a.subclientName = @compValue
					AND c.id > 1
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1       -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
				WHERE
					a.subclientName LIKE @compValue ESCAPE('\')
					AND c.id > 1
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1       -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
				WHERE
					a.subclientName = @compValue
					AND c.id > 1
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1       -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
				WHERE
					a.subclientName LIKE @compValue ESCAPE('\')
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1        -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0 								     -- Not Deleted
					AND c.id > 1
		END
		--ELSE empty table returned
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND c.id = @inClientId
				WHERE
					a.subclientName = @compValue
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1       -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND c.id = @inClientId
				WHERE
					a.subclientName LIKE @compValue ESCAPE('\')
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1       -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND c.id = @inClientId
				WHERE
					a.subclientName = @compValue
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1       -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				SELECT DISTINCT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_Application a WITH(READUNCOMMITTED) ON
						a.clientId = c.id
						AND c.id = @inClientId
				WHERE
					a.subclientName LIKE @compValue ESCAPE('\')
					AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1        -- subclient is valid
					AND (a.subclientStatus & (2|4)) = 0 								     -- Not Deleted
		END
		--ELSE empty table returned
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetSubclientName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetSubclientName' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'scgV2GetSubclientName',  '1.1.2.7', 'scgV2GetSubclientName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
