

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientsWithIDAsAssociatedToADUserGroupList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientsWithIDAsAssociatedToADUserGroupList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientsWithIDAsAssociatedToADUserGroupList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientsWithIDAsAssociatedToADUserGroupList]
  delete from GXDBVersions where name = 'scgV2GetClientsWithIDAsAssociatedToADUserGroupList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientsWithIDAsAssociatedToADUserGroupList(@operator varchar(16), @compValue XML, @inClientID INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @UserGroups TABLE (
		id	INT PRIMARY KEY
	)
	INSERT INTO @UserGroups (id)
		SELECT
			cg.value('@val', 'integer')
		FROM
			@compValue.nodes('/App_SCGRuleValueList/id')	l(cg)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- no client groups nothing to do
		RETURN
	END
	IF (@inClientID=0 )
	BEGIN
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM UMDSProviders p WITH(READUNCOMMITTED)
					INNER JOIN UMGroups g WITH(READUNCOMMITTED) ON
						g.umdsProviderId = p.id
						AND p.serviceType = 2			-- UMDS_PROVIDER_ACTIVE_DIR
					INNER JOIN @UserGroups ug ON
						ug.id = g.id
					INNER JOIN UMSecurityAssociations sa WITH(READUNCOMMITTED) ON
						sa.entityType1 = 3				-- CLIENT_ENTITY
						AND g.id = sa.userOrGroupId
						AND sa.isUser = 0
						AND sa.entityType2 = 4			-- APPTYPE_ENTITY
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = sa.entityId1
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
					AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
				EXCEPT
				SELECT DISTINCT
					c.id
				FROM UMDSProviders p WITH(READUNCOMMITTED)
					INNER JOIN UMGroups g WITH(READUNCOMMITTED) ON
						g.umdsProviderId = p.id
						AND p.serviceType = 2			-- UMDS_PROVIDER_ACTIVE_DIR
					INNER JOIN @UserGroups ug ON
						ug.id = g.id
					INNER JOIN UMSecurityAssociations sa WITH(READUNCOMMITTED) ON
						sa.entityType1 = 3				-- CLIENT_ENTITY
						AND g.id = sa.userOrGroupId
						AND sa.isUser = 0
						AND sa.entityType2 = 4			-- APPTYPE_ENTITY
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = sa.entityId1
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
		END
	END
	ELSE
	BEGIN
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id
				FROM UMDSProviders p WITH(READUNCOMMITTED)
					INNER JOIN UMGroups g WITH(READUNCOMMITTED) ON
						g.umdsProviderId = p.id
						AND p.serviceType = 2			-- UMDS_PROVIDER_ACTIVE_DIR
					INNER JOIN @UserGroups ug ON
						ug.id = g.id
					INNER JOIN UMSecurityAssociations sa WITH(READUNCOMMITTED) ON
						sa.entityType1 = 3				-- CLIENT_ENTITY
						AND g.id = sa.userOrGroupId
						AND sa.isUser = 0
						AND sa.entityType2 = 4			-- APPTYPE_ENTITY
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = sa.entityId1
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
				WHERE
					c.id = @inClientID
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientID
				EXCEPT
				SELECT DISTINCT
					c.id
				FROM UMDSProviders p WITH(READUNCOMMITTED)
					INNER JOIN UMGroups g WITH(READUNCOMMITTED) ON
						g.umdsProviderId = p.id
						AND p.serviceType = 2			-- UMDS_PROVIDER_ACTIVE_DIR
					INNER JOIN @UserGroups ug ON
						ug.id = g.id
					INNER JOIN UMSecurityAssociations sa WITH(READUNCOMMITTED) ON
						sa.entityType1 = 3				-- CLIENT_ENTITY
						AND g.id = sa.userOrGroupId
						AND sa.isUser = 0
						AND sa.entityType2 = 4			-- APPTYPE_ENTITY
					INNER JOIN APP_Client c WITH(READUNCOMMITTED) ON
						c.id = sa.entityId1
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
				WHERE
					c.id = @inClientID
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientsWithIDAsAssociatedToADUserGroupList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientsWithIDAsAssociatedToADUserGroupList' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'scgV2GetClientsWithIDAsAssociatedToADUserGroupList',  '1.1.2.1', 'scgV2GetClientsWithIDAsAssociatedToADUserGroupList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
