

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientTimezoneIdList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientTimezoneIdList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientTimezoneIdList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientTimezoneIdList]
  delete from GXDBVersions where name = 'scgV2GetClientTimezoneIdList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientTimezoneIdList(@operator VARCHAR(24), @compValue XML, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @Timezones TABLE (
		id	NVARCHAR(12) PRIMARY KEY
	)
	INSERT INTO @Timezones (id)
		SELECT
			cg.value('@val', 'NVARCHAR(12) ')
		FROM
			@compValue.nodes('/App_SCGRuleValueList/id')	l(cg)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- no Timezones nothing to do
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
					INNER JOIN @Timezones tz on
						tz.id = cp.attrVal
				WHERE
					c.id > 1
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
					INNER JOIN @Timezones tz on
						tz.id = cp.attrVal
				WHERE
					c.id > 1
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
					INNER JOIN @Timezones tz on
						tz.id = cp.attrVal
				WHERE
					c.id = @inClientId
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
					INNER JOIN @Timezones tz on
						tz.id = cp.attrVal
				WHERE
					c.id = @inClientId
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientTimezoneIdList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientTimezoneIdList' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2GetClientTimezoneIdList',  '1.1.2.4', 'scgV2GetClientTimezoneIdList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
