

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientTimezoneId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientTimezoneId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientTimezoneId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientTimezoneId]
  delete from GXDBVersions where name = 'scgV2GetClientTimezoneId' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientTimezoneId(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
				WHERE
					c.id > 1
					AND CAST(cp.attrVal AS INT) = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
				WHERE
					c.id > 1
					AND CAST(cp.attrVal AS INT) = @compValue
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
				WHERE
					c.id = @inClientId
					AND CAST(cp.attrVal AS INT) = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
						cp.componentNameId = c.id
						AND cp.modified = 0
						AND cp.attrName = N'timezone Id'
				WHERE
					c.id = @inClientId
					AND CAST(cp.attrVal AS INT) = @compValue
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientTimezoneId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientTimezoneId' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2GetClientTimezoneId',  '1.1.2.5', 'scgV2GetClientTimezoneId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
