

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientProps.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientProps'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientProps]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientProps]
  delete from GXDBVersions where name = 'scgV2GetClientProps' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientProps(@operator varchar(16), @clientProp integer, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		--Installed
		IF (@clientProp = 1)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.specialClientFlags & 2) = 0
						AND c.id > 1
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.specialClientFlags & 2) <> 0
						AND c.id > 1
			END
			RETURN
		END
		--Licensed
		IF (@clientProp = 2)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.status & 0x2) <> 2
						AND c.id > 1
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.status & 0x2) = 2
						AND c.id > 1
			END
			RETURN
		END
		--VM (VSA Discovered)
		IF (@clientProp = 3)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Server Discovered Clients'
							AND cp.attrVal = '1'
					WHERE
						c.id > 1
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Server Discovered Clients'
					WHERE
						c.id > 1
						AND (
							cp.attrVal IS NULL
							OR cp.attrVal <> '1'
						)
			END
			RETURN
		END
		--1 Touch Enabled(unix only)
		IF (@clientProp = 4)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_APPLICATION a WITH(READUNCOMMITTED) ON c.id = a.clientid
						INNER JOIN  simOperatingSystem S WITH(READUNCOMMITTED) ON c.simOperatingSystemId = S.id
					WHERE c.id > 1
						AND A.subclientStatus&256=256
						AND S.type = 'Unix'
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT id
					FROM App_client WITH(READUNCOMMITTED)
					WHERE id > 1
						AND id NOT IN
							(
								SELECT DISTINCT
									c.id clientId
								FROM APP_Client c WITH(READUNCOMMITTED)
									INNER JOIN APP_APPLICATION a WITH(READUNCOMMITTED) ON c.id = a.clientid
									INNER JOIN  simOperatingSystem S WITH(READUNCOMMITTED) ON c.simOperatingSystemId = S.id
								WHERE c.id > 1
									AND A.subclientStatus&256=256
									AND S.type = 'Unix'
							)
			END
			RETURN
		END
		--MEDIA AGENT --Look for media agents in the MMHost because cluster media agents will not have package in simInstalledPackages
		IF (@clientProp = 5)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN MMHost h WITH(READUNCOMMITTED) ON
							h.ClientId = c.id
					WHERE
						h.ClientId > 1
						AND h.ClientId NOT IN (SELECT PMClientId FROM APP_VMToPMMap WITH(READUNCOMMITTED) WHERE VMClientId = 2)
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN MMHost h WITH(READUNCOMMITTED) ON
							h.ClientId = c.id
					WHERE
						h.ClientId IS NULL
						OR NOT (
							h.ClientId > 1
							AND h.ClientId NOT IN (SELECT PMClientId FROM APP_VMToPMMap WITH(READUNCOMMITTED) WHERE VMClientId = 2)
						)
			END
		END
		--Virtual (Cluster Node)
		IF (@clientProp = 6)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Client'
							AND cp.attrVal = '1'
					WHERE
						c.id > 1
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Client'
					WHERE
						c.id > 1
						AND (
							cp.attrVal IS NULL
							OR cp.attrVal <> '1'
						)
			END
			RETURN
		END
		--Laptop Client
		IF (@clientProp = 7)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 4096) = 4096  --Removed Personal Workstation Attrname reference
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 4096) <> 4096 --Removed Personal Workstation Attrname reference
			END
			RETURN
		END
		--Reference copy client
		IF (@clientProp = 8)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 0x4000000) = 0x4000000		-- CV_STATUS_REFERENCE_COPY
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 0x4000000) <> 0x4000000		-- CV_STATUS_REFERENCE_COPY
			END
			RETURN
		END
		--Edge Clients
		IF (@clientProp = 9)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 0x10000000) = 0x10000000		-- CV_STATUS_EDGE_DRIVE
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 0x10000000) <> 0x10000000		-- CV_STATUS_EDGE_DRIVE
			END
			RETURN
		END
		--NAS Clients
		-- 16 = SIM_ID_NAS_OS = NetApp
		-- 17 = SIM_ID_EMC_CELERRA_OS = Celerra
		-- 18 = SIM_ID_EMC_CHAMELEON_FILER_OS = IP4700 (no longer supported)
		-- 29 = SIM_ID_BLUEARC_FILER_OS = BlueArc
		-- 45 = SIM_ID_HITACHI_ENAS_OS = Hitachi ENAS
		-- 55 = SIM_ID_EMC_CENTERA_OS = Centera, but we never actually shipped that
		-- 19 = SIM_ID_GENERIC_FILER_OS = Isilon, Pillar, Oracle, ... all others
		-- But this is all handled by SIM. The simOperatingSystem table will have subtype NAS
		IF (@clientProp = 10)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
							c.simOperatingSystemId = os.id
					WHERE
						c.id > 1
						AND os.id IS NOT NULL
						AND os.SubType = 'NAS'
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
							c.simOperatingSystemId = os.id
					WHERE
						c.id > 1
						AND (
							os.id IS NULL
							OR os.SubType <> 'NAS'
						)
			END
			RETURN
		END
		IF (@clientProp = 11)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = 2
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 2
			END
			RETURN
		END
		IF (@clientProp = 12)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON cp.componentNameId = c.id AND cp.modified = 0 AND cp.attrName = 'IsPhysicalNodeOfACluster'
					WHERE c.id > 1 AND cp.attrVal = '1'
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON cp.componentNameId = c.id AND cp.modified = 0 AND cp.attrName = 'IsPhysicalNodeOfACluster'
					WHERE c.id > 1 AND (cp.attrVal IS NULL OR cp.attrVal <> '1')
			END
			RETURN
		END
		IF (@clientProp = 13)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
WHERE C.Status &  0x20000000=0x20000000
					AND (C.[status] & (2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
						SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
						 JOIN App_Application App  WITH(READUNCOMMITTED) ON App.clientId = C.id
					WHERE  (C.[status] & (2|4)) = 0 AND   App.appTypeId =81
                    EXCEPT
					SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
WHERE C.Status &  0x20000000=0x20000000
					AND (C.[status] & (2|4)) = 0
			END
			RETURN
		END
		IF (@clientProp = 14)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
					   C.ID
				FROM  App_client C  WITH(READUNCOMMITTED)
WHERE Status & 0x200000=0x200000
				AND (C.[status] & (2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
						   C.id
					FROM App_client C  WITH(READUNCOMMITTED)
						 JOIN App_Application App   WITH(READUNCOMMITTED) ON App.clientId = C.id
					WHERE App.appTypeId  IN (35, 54, 82, 137) AND (C.[status]&(2|4)) = 0
				EXCEPT
					SELECT DISTINCT
					   C.ID
				FROM  App_client C    WITH(READUNCOMMITTED)
WHERE Status & 0x200000=0x200000
				AND (C.[status] & (2|4)) = 0
			END
			RETURN
		END
		IF (@clientProp = 15)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
WHERE C.Status & 0x0040=0x0040   --CV_STATUS_ORACLE_RAC
						AND (C.[status] & (2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
						 JOIN App_Application App WITH(READUNCOMMITTED) ON App.clientId = C.id
					  WHERE (C.[status]&(2|4)) = 0 AND  App.appTypeId in (2,22)
			END
			RETURN
		END
		IF (@clientProp = 16)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
					   c.id
				FROM IdxSIDBSubStore IDX WITH (READUNCOMMITTED),
					 APP_Client C WITH (READUNCOMMITTED)
				WHERE IDX.clientId = C.id
					  AND (C.[status]&(2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT c.ID
					FROM App_Client C WITH (READUNCOMMITTED)
					WHERE (C.[status]&(2|4)) = 0
					EXCEPT
					SELECT DISTINCT
						   c.id
					FROM IdxSIDBSubStore IDX WITH (READUNCOMMITTED),
						 APP_Client C WITH (READUNCOMMITTED)
					WHERE IDX.clientId = C.id
						  AND (C.[status]&(2|4)) = 0
			END
			RETURN
		END
		IF (@clientProp = 17)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.attrName = 'Linked CS Client' -- CV_PROP_FAILOVER_LINKED_CS_CLIENT
							AND cp.attrVal = CONVERT(NVARCHAR(10),c.id)
							AND cp.modified = 0
					WHERE
						c.id > 1 AND (C.[status]&(2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.attrName = 'Linked CS Client' -- CV_PROP_FAILOVER_LINKED_CS_CLIENT
							AND cp.attrVal = CONVERT(NVARCHAR(10),c.id)
							AND cp.modified = 0
					WHERE
						c.id > 1 AND (C.[status]&(2|4)) = 0  AND cp.attrVal IS NULL
			END
			RETURN
		END
		IF (@clientProp = 18)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT App_client.id clientId
					FROM App_Application App WITH (NOLOCK)
					INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
					INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
					INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
					INNER JOIN MMDataPath (NOLOCK) ON MMDataPath.CopyID= ArchGroupCopy.ID
					INNER JOIN App_client (NOLOCK) ON App_client.Id = MMDataPath.HostClientID
						AND App_client.id > 1 AND (App_client.[status]&(2|4)) = 0
				UNION
				SELECT App_client.id clientId
					FROM App_Application App WITH (NOLOCK)
					INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
					INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
					INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
					INNER JOIN ArchCopySIDBStore (NOLOCK) ON ArchCopySIDBStore.CopyId = ArchGroupCopy.id
					INNER JOIN IdxSIDBSubStore (NOLOCK) ON IdxSIDBSubStore.SIDBStoreId = ArchCopySIDBStore.SIDBStoreId AND IdxSIDBSubStore.sealedTime = 0
					INNER JOIN App_client (NOLOCK) ON App_client.Id = IdxSIDBSubStore.ClientId
						AND App_client.id > 1 AND (App_client.[status]&(2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT JOIN
					(
						SELECT App_client.id clientId
							FROM App_Application App WITH (NOLOCK)
							INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
							INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
							INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
							INNER JOIN MMDataPath (NOLOCK) ON MMDataPath.CopyID= ArchGroupCopy.ID
							INNER JOIN App_client (NOLOCK) ON App_client.Id = MMDataPath.HostClientID
								AND App_client.id > 1 AND (App_client.[status]&(2|4)) = 0
						UNION
						SELECT App_client.id clientId
							FROM App_Application App WITH(READUNCOMMITTED)
							INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
							INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
							INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
							INNER JOIN ArchCopySIDBStore (NOLOCK) ON ArchCopySIDBStore.CopyId = ArchGroupCopy.id
							INNER JOIN IdxSIDBSubStore (NOLOCK) ON IdxSIDBSubStore.SIDBStoreId = ArchCopySIDBStore.SIDBStoreId AND IdxSIDBSubStore.sealedTime = 0
							INNER JOIN App_client (NOLOCK) ON App_client.Id = IdxSIDBSubStore.ClientId
								AND App_client.id > 1 AND (App_client.[status]&(2|4)) = 0
					) AssociatedClients
					ON AssociatedClients.clientID = c.id
					WHERE c.id > 1 AND (C.[status]&(2|4)) = 0  AND AssociatedClients.clientID IS NULL
			END
			RETURN
		END
		ELSE IF (@clientProp = 19)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Case Manager Pseudo Client' -- CV_PROP_CASE_MANAGER_PSEUDO_CLIENT
							AND cp.attrVal = '1'
					WHERE
						c.id > 1 AND (C.[status]&(2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Case Manager Pseudo Client' -- CV_PROP_CASE_MANAGER_PSEUDO_CLIENT
					WHERE
						c.id > 1
						AND (
							cp.attrVal IS NULL
							OR cp.attrVal <> '1'
						)
			END
			RETURN
		END
	END
	ELSE
	BEGIN
		-- Given client
		--Installed
		IF (@clientProp = 1)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.specialClientFlags & 2) = 0
						AND c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.specialClientFlags & 2) <> 0
						AND c.id = @inClientId
			END
			RETURN
		END
		--Licensed
		IF (@clientProp = 2)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.status & 0x2) <> 2
						AND c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						(c.status & 0x2) = 2
						AND c.id = @inClientId
			END
			RETURN
		END
		--VM (VSA Discovered)
		IF (@clientProp = 3)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Server Discovered Clients'
							AND cp.attrVal = '1'
					WHERE
						c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Server Discovered Clients'
					WHERE
						c.id = @inClientId
						AND (
							cp.attrVal IS NULL
							OR cp.attrVal <> '1'
						)
			END
			RETURN
		END
		--1 Touch Enabled(unix only)
		IF (@clientProp = 4)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_APPLICATION a WITH(READUNCOMMITTED) ON c.id = a.clientid
						INNER JOIN  simOperatingSystem S WITH(READUNCOMMITTED) ON c.simOperatingSystemId = S.id
					WHERE c.id = @inClientId
						AND A.subclientStatus&256=256
						AND S.type = 'Unix'
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT id
					FROM App_client WITH(READUNCOMMITTED)
					WHERE id = @inClientId
						AND id NOT IN
							(
								SELECT DISTINCT
									c.id clientId
								FROM APP_Client c WITH(READUNCOMMITTED)
									INNER JOIN APP_APPLICATION a WITH(READUNCOMMITTED) ON c.id = a.clientid
									INNER JOIN  simOperatingSystem S WITH(READUNCOMMITTED) ON c.simOperatingSystemId = S.id
								WHERE c.id > 1
									AND A.subclientStatus&256=256
									AND S.type = 'Unix'
							)
			END
			RETURN
		END
		--MEDIA AGENT --Look for media agents in the MMHost because cluster media agents will not have package in simInstalledPackages
		IF (@clientProp = 5)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN MMHost h WITH(READUNCOMMITTED) ON
							h.ClientId = c.id
					WHERE
						h.ClientId = @inClientId
						AND h.ClientId NOT IN (SELECT PMClientId FROM APP_VMToPMMap WITH(READUNCOMMITTED) WHERE VMClientId = 2)
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN MMHost h WITH(READUNCOMMITTED) ON
							h.ClientId = c.id
					WHERE
						h.ClientId IS NULL
						OR NOT (
							h.ClientId = @inClientId
							AND h.ClientId NOT IN (SELECT PMClientId FROM APP_VMToPMMap WITH(READUNCOMMITTED) WHERE VMClientId = 2)
						)
			END
		END
		--Virtual (Cluster Node)
		IF (@clientProp = 6)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Client'
							AND cp.attrVal = '1'
					WHERE
						c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Virtual Client'
					WHERE
						c.id = @inClientId
						AND (
							cp.attrVal IS NULL
							OR cp.attrVal <> '1'
						)
			END
			RETURN
		END
		--Laptop Client
		IF (@clientProp = 7)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 4096) = 4096 --Removed Personal Workstation Attrname reference
						AND c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & 4096) <> 4096 --Removed Personal Workstation Attrname reference
						AND c.id = @inClientId
			END
			RETURN
		END
		--Reference copy client
		IF (@clientProp = 8)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = @inClientId
						AND (c.status & 0x4000000) = 0x4000000		-- CV_STATUS_REFERENCE_COPY
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = @inClientId
						AND (c.status & 0x4000000) <> 0x4000000		-- CV_STATUS_REFERENCE_COPY
			END
			RETURN
		END
		--Edge Clients
		IF (@clientProp = 9)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = @inClientId
						AND (c.status & 0x10000000) = 0x10000000		-- CV_STATUS_EDGE_DRIVE
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = @inClientId
						AND (c.status & 0x10000000) <> 0x10000000		-- CV_STATUS_EDGE_DRIVE
			END
			RETURN
		END
		--NAS Clients
		-- 16 = SIM_ID_NAS_OS = NetApp
		-- 17 = SIM_ID_EMC_CELERRA_OS = Celerra
		-- 18 = SIM_ID_EMC_CHAMELEON_FILER_OS = IP4700 (no longer supported)
		-- 29 = SIM_ID_BLUEARC_FILER_OS = BlueArc
		-- 45 = SIM_ID_HITACHI_ENAS_OS = Hitachi ENAS
		-- 55 = SIM_ID_EMC_CENTERA_OS = Centera, but we never actually shipped that
		-- 19 = SIM_ID_GENERIC_FILER_OS = Isilon, Pillar, Oracle, ... all others
		-- But this is all handled by SIM. The simOperatingSystem table will have subtype NAS
		IF (@clientProp = 10)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
							c.simOperatingSystemId = os.id
					WHERE
						c.id = @inClientId
						AND os.id IS NOT NULL
						AND os.SubType = 'NAS'
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
							c.simOperatingSystemId = os.id
					WHERE
						c.id = @inClientId
						AND (
							os.id IS NULL
							OR os.SubType <> 'NAS'
						)
			END
			RETURN
		END
		IF (@clientProp = 11)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = 2
						AND c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 2
						AND c.id = @inClientId
			END
			RETURN
		END
		IF (@clientProp = 12)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON cp.componentNameId = c.id AND cp.modified = 0 AND cp.attrName = 'IsPhysicalNodeOfACluster'
					WHERE c.id = @inClientId
						AND cp.attrVal = '1'
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON cp.componentNameId = c.id AND cp.modified = 0 AND cp.attrName = 'IsPhysicalNodeOfACluster'
					WHERE c.id = @inClientId
						AND (cp.attrVal IS NULL OR cp.attrVal <> '1')
			END
			RETURN
		END
			IF (@clientProp = 13)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
WHERE C.Status &  0x20000000=0x20000000
					AND (C.[status] & (2|4)) = 0
					AND C.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
						SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
						 JOIN App_Application App WITH(READUNCOMMITTED) ON App.clientId = C.id
					WHERE  (C.[status] & (2|4)) = 0
							AND   App.appTypeId =81
							AND C.id = @inClientId
                    EXCEPT
					SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
WHERE C.Status &  0x20000000=0x20000000 --CV_STATUS_MSSQLAG
					     AND (C.[status] & (2|4)) = 0
						 AND C.id = @inClientId
			END
			RETURN
		END
		IF (@clientProp = 14)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
					   C.ID
				FROM App_client C WITH(READUNCOMMITTED)
WHERE Status & 0x200000=0x200000   --CV_STATUS_DAG
					  AND C.id = @inClientId
					  AND (C.[status] & (2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
						   C.id
					FROM App_client C WITH(READUNCOMMITTED)
						 JOIN App_Application App WITH(READUNCOMMITTED) ON App.clientId = C.id
					WHERE App.appTypeId  IN (35, 54, 82, 137) AND C.id = @inClientId
					AND (C.[status] & (2|4)) = 0
				EXCEPT
					SELECT DISTINCT
					   C.ID
				FROM App_client C  WITH(READUNCOMMITTED)
WHERE Status & 0x200000=0x200000
					  AND C.id = @inClientId
					  AND (C.[status] & (2|4)) = 0
			END
			RETURN
		END
		IF (@clientProp = 15)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
					   C.ID
				FROM App_client C WITH(READUNCOMMITTED)
WHERE C.Status & 0x0040=0x0040   --CV_STATUS_ORACLE_RAC
					  AND C.id = @inClientId
					  AND (C.[status] & (2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						   C.id
					FROM App_client C  WITH(READUNCOMMITTED)
						 JOIN App_Application App   WITH(READUNCOMMITTED) ON App.clientId = C.id
					  WHERE (C.[status]&(2|4)) = 0
					  AND  App.appTypeId in (2,22)
					  AND C.id = @inClientId
			END
			RETURN
		END
		IF (@clientProp = 16)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT
					   c.id
				FROM IdxSIDBSubStore IDX WITH (READUNCOMMITTED),
					 APP_Client C WITH (READUNCOMMITTED)
				WHERE IDX.clientId = C.id
					  AND (C.[status]&(2|4)) = 0
					  AND C.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT c.ID
					FROM App_Client C WITH (READUNCOMMITTED)
					WHERE (C.[status]&(2|4)) = 0 AND C.id = @inClientId
					EXCEPT
					SELECT DISTINCT
						   c.id
					FROM IdxSIDBSubStore IDX WITH (READUNCOMMITTED),
						 APP_Client C WITH (READUNCOMMITTED)
					WHERE IDX.clientId = C.id
						  AND (C.[status]&(2|4)) = 0 AND  C.id = @inClientId
			END
			RETURN
		END
		IF (@clientProp = 17)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT DISTINCT c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.attrName = 'Linked CS Client' -- CV_PROP_FAILOVER_LINKED_CS_CLIENT
							AND cp.attrVal = CONVERT(NVARCHAR(10),c.id)
							AND cp.modified = 0
					WHERE
						c.id > 1 AND (C.[status]&(2|4)) = 0
						AND c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.attrName = 'Linked CS Client' -- CV_PROP_FAILOVER_LINKED_CS_CLIENT
							AND cp.attrVal = CONVERT(NVARCHAR(10),c.id)
							AND cp.modified = 0
					WHERE
						c.id > 1 AND (C.[status]&(2|4)) = 0
						AND c.id = @inClientId
						AND cp.attrName IS NULL
			END
			RETURN
		END
		IF (@clientProp = 18)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
				SELECT App_client.id clientId
					FROM App_Application App WITH (NOLOCK)
					INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
					INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
					INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
					INNER JOIN MMDataPath (NOLOCK) ON MMDataPath.CopyID= ArchGroupCopy.ID
					INNER JOIN App_client (NOLOCK) ON App_client.Id = MMDataPath.HostClientID
						AND App_client.id = @inClientId AND (App_client.[status]&(2|4)) = 0
				UNION
				SELECT App_client.id clientId
					FROM App_Application App WITH(READUNCOMMITTED)
					INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
					INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
					INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
					INNER JOIN ArchCopySIDBStore (NOLOCK) ON ArchCopySIDBStore.CopyId = ArchGroupCopy.id
					INNER JOIN IdxSIDBSubStore (NOLOCK) ON IdxSIDBSubStore.SIDBStoreId = ArchCopySIDBStore.SIDBStoreId AND IdxSIDBSubStore.sealedTime = 0
					INNER JOIN App_client (NOLOCK) ON App_client.Id = IdxSIDBSubStore.ClientId
						AND App_client.id = @inClientId AND (App_client.[status]&(2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT JOIN
					(
						SELECT App_client.id clientId
							FROM App_Application App WITH (NOLOCK)
							INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
							INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
							INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
							INNER JOIN MMDataPath (NOLOCK) ON MMDataPath.CopyID= ArchGroupCopy.ID
							INNER JOIN App_client (NOLOCK) ON App_client.Id = MMDataPath.HostClientID
								AND App_client.id = @inClientId AND (App_client.[status]&(2|4)) = 0
						UNION
						SELECT App_client.id clientId
							FROM App_Application App WITH(READUNCOMMITTED)
							INNER JOIN CvFailoverLogShippingScInfo (NOLOCK) ON CvFailoverLogShippingScInfo.LogShippingSubclientId = App.ID
							INNER JOIN ArchGroup (NOLOCK) ON (App.dataArchGrpID = ArchGroup.ID OR App.logArchGrpID = ArchGroup.ID)
							INNER JOIN ArchGroupCopy (NOLOCK) ON ArchGroupCopy.archGroupId = ArchGroup.ID
							INNER JOIN ArchCopySIDBStore (NOLOCK) ON ArchCopySIDBStore.CopyId = ArchGroupCopy.id
							INNER JOIN IdxSIDBSubStore (NOLOCK) ON IdxSIDBSubStore.SIDBStoreId = ArchCopySIDBStore.SIDBStoreId AND IdxSIDBSubStore.sealedTime = 0
							INNER JOIN App_client (NOLOCK) ON App_client.Id = IdxSIDBSubStore.ClientId
								AND App_client.id = @inClientId AND (App_client.[status]&(2|4)) = 0
					) AssociatedClients
					ON AssociatedClients.clientID = c.id
					WHERE c.id = @inClientId AND (C.[status]&(2|4)) = 0  AND AssociatedClients.clientID IS NULL
			END
			RETURN
		END
		IF (@clientProp = 19)
		BEGIN
			IF (@opType = 1)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						INNER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Case Manager Pseudo Client' -- CV_PROP_CASE_MANAGER_PSEUDO_CLIENT
							AND cp.attrVal = '1'
					WHERE
						c.id > 1 AND c.id = @inClientId
						AND (C.[status]&(2|4)) = 0
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN APP_ClientProp cp WITH(READUNCOMMITTED) ON
							cp.componentNameId = c.id
							AND cp.modified = 0
							AND cp.attrName = 'Case Manager Pseudo Client' -- CV_PROP_CASE_MANAGER_PSEUDO_CLIENT
					WHERE
						c.id > 1
						AND c.id = @inClientId
						AND (
							cp.attrVal IS NULL
							OR cp.attrVal <> '1'
						)
			END
			RETURN
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientProps]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientProps' AND revision = '1.1.2.13.36.1')

  insert into GXDBVersions values(5, 'scgV2GetClientProps',  '1.1.2.13.36.1', 'scgV2GetClientProps', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
