

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientProductVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientProductVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientProductVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientProductVersion]
  delete from GXDBVersions where name = 'scgV2GetClientProductVersion' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientProductVersion(@operator VARCHAR(24), @compValue NVARCHAR(1024), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.productVersion = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.productVersion <> @compValue
		END ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.productVersion LIKE @compValue  ESCAPE('\')
		END ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.productVersion NOT LIKE @compValue  ESCAPE('\')
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.productVersion = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.productVersion <> @compValue
		END ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.productVersion LIKE @compValue  ESCAPE('\')
		END ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.clientId
				FROM ClientProductVersionView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.productVersion NOT LIKE @compValue  ESCAPE('\')
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientProductVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientProductVersion' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2GetClientProductVersion',  '1.1.2.5', 'scgV2GetClientProductVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
