

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientOnlineDays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientOnlineDays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientOnlineDays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientOnlineDays]
  delete from GXDBVersions where name = 'scgV2GetClientOnlineDays' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientOnlineDays(@operator VARCHAR(24), @compValue INT, @secCompValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN '>' THEN 3
							WHEN '>=' THEN 4
							WHEN '<' THEN 5
							WHEN '<=' THEN 6
							WHEN 'BETWEEN' THEN 7
							WHEN 'NOT BETWEEN' THEN 8
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
 	DECLARE @now				INT = dbo.GetUnixTime(GetUTCDate())
 	DECLARE @sec1				BIGINT = (CAST(@compValue AS BIGINT) * 86400)		-- convert days to seconds
	IF (@now < @sec1)
	BEGIN
		RETURN	-- inputted days too large to proceess against current time
	END
 	DECLARE @day1			INT = 0
 	DECLARE @day2			INT = 0
 	DECLARE @onlineAtCheck	INT = @now - @sec1
 	DECLARE @onlineAtCheck2	INT = 0
 	IF (@secCompValue IS NOT NULL)
 	BEGIN
 		DECLARE @sec2	BIGINT = (CAST(@secCompValue AS BIGINT) * 86400)	-- convert days to seconds
		IF (@now < @sec2)
		BEGIN
			RETURN	-- inputted days too large to proceess against current time
		END
 		SET @onlineAtCheck2 = @now - @sec2
 	END
 	DECLARE @list TABLE (
 		clientId		INT,
 		lastOnlineTime	INT,
 		isOnline		INT,
 		daysOnline		INT,
 		PRIMARY KEY(lastOnlineTime, clientId)
 	)
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
 		INSERT INTO @list
 			SELECT DISTINCT
 				c.id clientId,
 				q.lastOnlineTime,
 				q.isOnline,
 				CASE q.isOnline			-- if online compute how many days it is online for
 					WHEN 1 THEN CAST(ROUND((@now - q.lastOnlineTime) / 86400.00,0) as INT)    --(24*3600) day converted to seconds  --(24*3600) day converted to seconds
 					ELSE 0
 				END
 			FROM
 				APP_Client c WITH(READUNCOMMITTED)
 				LEFT OUTER JOIN (
 					SELECT
 						ctc.ToClientId clientId,
 						ctc.lastOnlineTime,
 						ctc.lastOfflineTime,
 						CASE
 							WHEN ctc.lastOfflineTime < ctc.lastOnlineTime THEN 1
 							ELSE 0	-- offline
 						END isOnline,
 						ROW_NUMBER() over (PARTITION BY  ctc.ToClientId ORDER BY ctc.lastOnlineTime DESC) number		-- latest row is number=1
 					FROM CCRClientToClient ctc WITH(NOLOCK)
 					WHERE
 						ctc.FromClientId = 2	-- only want status of CS client to client
 						AND ctc.serviceType = 0
 				) q ON
 					c.id = q.clientId
 			WHERE
 				q.number IS NOT NULL		-- look at rows that have online status set, if no join rows ignore client its status is unknown at this point in time
 				AND q.number = 1
 				AND q.lastOnlineTime <> 0	-- if equal to 0, it was never online
	END
	ELSE
	BEGIN
		-- Given client
 		INSERT INTO @list
 			SELECT DISTINCT
 				c.id clientId,
 				q.lastOnlineTime,
 				q.isOnline,
 				CASE q.isOnline			-- if online compute how many days it is online for
 					WHEN 1 THEN CAST(ROUND((@now - q.lastOnlineTime) / 86400.00,0) as INT)    --(24*3600) day converted to seconds  --(24*3600) day converted to seconds
 					ELSE 0
 				END
 			FROM
 				APP_Client c WITH(READUNCOMMITTED)
 				LEFT OUTER JOIN (
 					SELECT
 						ctc.ToClientId clientId,
 						ctc.lastOnlineTime,
 						ctc.lastOfflineTime,
 						CASE
 							WHEN ctc.lastOfflineTime < ctc.lastOnlineTime THEN 1
 							ELSE 0	-- offline
 						END isOnline,
 						ROW_NUMBER() over (PARTITION BY  ctc.ToClientId ORDER BY ctc.lastOnlineTime DESC) number		-- latest row is number=1
 					FROM CCRClientToClient ctc WITH(NOLOCK)
 					WHERE
 						ctc.FromClientId = 2	-- only want status of CS client to client
 						AND ctc.serviceType = 0
						AND ctc.ToClientId = @inClientId
 				) q ON
 					c.id = q.clientId
 			WHERE
 				q.number IS NOT NULL		-- look at rows that have online status set, if no join rows ignore client its status is unknown at this point in time
 				AND q.number = 1
 				AND q.lastOnlineTime <> 0	-- if equal to 0, it was never online
				AND c.id = @inClientId
	END
 	IF (@opType = 1)
 	BEGIN
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				-- ignore inputed days, only want to know if client is online NOW!
 				AND t.isOnline = 1
 	END
 	ELSE IF (@opType = 2)
 	BEGIN
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				-- ignore inputed days, only want to know if client offline NOW!
 				AND t.isOnline = 0
 	END
 	ELSE IF (@opType = 3)
 	BEGIN	-- get clients that have been onlines > N days - with how CCR updates works this is not possible just check if online NOW
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND t.isOnline = 1
 				--AND @onlineAtCheck > t.lastOnlineTime
 				--AND t.isOnline = 1
 				--AND t.daysOnline > @compValue
 	END
 	ELSE IF (@opType = 4)
 	BEGIN	-- get clients that have been onlines >= N days - with how CCR updates works this is not possible just check if online NOW
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND t.isOnline = 1
 				--AND @onlineAtCheck >= t.lastOnlineTime
 				--AND t.isOnline = 1
 				--AND t.daysOnline >= @compValue
 	END
 	ELSE IF (@opType = 5)
 	BEGIN	-- client is currently online or was online at least once during this period
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND (
 					@onlineAtCheck < t.lastOnlineTime
 					OR t.isOnline = 1	-- currently online
 				)
 	END
 	ELSE IF (@opType = 6)
 	BEGIN	-- client is currently online or was online at least once during this period
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND (
 					@onlineAtCheck <= t.lastOnlineTime
 					OR t.isOnline = 1	-- currently online
 				)
 	END
 	ELSE IF (@opType = 7)
 	BEGIN	-- get clients that came online between these times
 		IF (@onlineAtCheck < @onlineAtCheck2)
 		BEGIN
 			SET @day1 = @onlineAtCheck
 			SET @day2 = @onlineAtCheck2
 		END
 		ELSE
 		BEGIN
 			SET @day1 = @onlineAtCheck2
 			SET @day2 = @onlineAtCheck
 		END
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND t.lastOnlineTime BETWEEN @day1 AND @day2
 	END
 	ELSE IF (@opType = 8)
 	BEGIN	-- get clients that came online before or after these times
 		IF (@onlineAtCheck < @onlineAtCheck2)
 		BEGIN
 			SET @day1 = @onlineAtCheck
 			SET @day2 = @onlineAtCheck2
 		END
 		ELSE
 		BEGIN
 			SET @day1 = @onlineAtCheck2
 			SET @day2 = @onlineAtCheck
 		END
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND t.lastOnlineTime NOT BETWEEN @day1 AND @day2
 	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientOnlineDays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientOnlineDays' AND revision = '1.1.2.8')

  insert into GXDBVersions values(5, 'scgV2GetClientOnlineDays',  '1.1.2.8', 'scgV2GetClientOnlineDays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
