

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientOfflineDays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientOfflineDays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientOfflineDays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientOfflineDays]
  delete from GXDBVersions where name = 'scgV2GetClientOfflineDays' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientOfflineDays(@operator VARCHAR(24), @compValue INT, @secCompValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN '>' THEN 3
							WHEN '>=' THEN 4
							WHEN '<' THEN 5
							WHEN '<=' THEN 6
							WHEN 'BETWEEN' THEN 7
							WHEN 'NOT BETWEEN' THEN 8
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
 	DECLARE @now				INT = dbo.GetUnixTime(GetUTCDate())
 	DECLARE @sec1				BIGINT = (CAST(@compValue AS BIGINT) * 86400)		-- convert days to seconds
	IF (@now < @sec1)
	BEGIN
		RETURN	-- inputted days too large to proceess against current time
	END
 	DECLARE @day1				INT = 0
 	DECLARE @day2				INT = 0
 	DECLARE @offlineAtCheck		INT = @now - @sec1
 	DECLARE @offlineAtCheck2	INT = 0
 	IF (@secCompValue IS NOT NULL)
 	BEGIN
 		DECLARE @sec2	BIGINT = (CAST(@secCompValue AS BIGINT) * 86400)	-- convert days to seconds
		IF (@now < @sec2)
		BEGIN
			RETURN	-- inputted days too large to proceess against current time
		END
 		SET @offlineAtCheck2 = @now - @sec2
 	END
 	DECLARE @list TABLE (
 		clientId		INT,
 		lastOfflineTime	INT,
 		isOnline		INT,
 		daysOffline		INT,
 		PRIMARY KEY(lastOfflineTime, clientId)
 	)
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
 		INSERT INTO @list
 			SELECT DISTINCT
 				c.id clientId,
 				ISNULL(q.lastOfflineTime, 0),
 				ISNULL(q.isOnline, 0),
 				CASE ISNULL(q.isOnline, -1)			-- if offline compute how many days it is offline for
 					WHEN 0 THEN CAST(ROUND((@now - q.lastOfflineTime) / 86400.00,0) as INT)  --(24*3600) day converted to seconds
 					WHEN -1 THEN -1		-- unknown
 					ELSE 0
 				END
 			FROM
 				APP_Client c WITH(READUNCOMMITTED)
 				LEFT OUTER JOIN (
 					SELECT
 						ctc.ToClientId clientId,
 						ctc.lastOfflineTime,
 						CASE
 							WHEN ctc.lastOfflineTime < ctc.lastOnlineTime THEN 1
 							ELSE 0	-- offline
 						END isOnline,
 						ROW_NUMBER() over (PARTITION BY  ctc.ToClientId ORDER BY ctc.lastOfflineTime DESC) number		-- latest row is number=1
 					FROM CCRClientToClient ctc WITH(NOLOCK)
 					WHERE
 						ctc.FromClientId = 2	-- only want status of CS client to client
 						AND ctc.serviceType = 0
 				) q ON
 					c.id = q.clientId
 			WHERE
				 (C.[status] & (2|4)) = 0  AND (
 				q.number IS NULL		-- if no join rows assume it is offline by default, set offline time to 0 (epoch)
 				OR q.number = 1)
	END
	ELSE
	BEGIN
		-- Given client
 		INSERT INTO @list
 			SELECT DISTINCT
 				c.id clientId,
 				ISNULL(q.lastOfflineTime, 0),
 				ISNULL(q.isOnline, 0),
 				CASE ISNULL(q.isOnline, -1)			-- if offline compute how many days it is offline for
 					WHEN 0 THEN CAST(ROUND((@now - q.lastOfflineTime) / 86400.00,0) as INT)  --(24*3600) day converted to seconds
 					WHEN -1 THEN -1		-- unknown
 					ELSE 0
 				END
 			FROM
 				APP_Client c WITH(READUNCOMMITTED)
 				LEFT OUTER JOIN (
 					SELECT
 						ctc.ToClientId clientId,
 						ctc.lastOfflineTime,
 						CASE
 							WHEN ctc.lastOfflineTime < ctc.lastOnlineTime THEN 1
 							ELSE 0	-- offline
 						END isOnline,
 						ROW_NUMBER() over (PARTITION BY  ctc.ToClientId ORDER BY ctc.lastOfflineTime DESC) number		-- latest row is number=1
 					FROM CCRClientToClient ctc WITH(NOLOCK)
 					WHERE
 						ctc.FromClientId = 2	-- only want status of CS client to client
 						AND ctc.serviceType = 0
						AND ctc.ToClientId = @inClientId
 				) q ON
 					c.id = q.clientId
 			WHERE
				c.id = @inClientId AND C.[status] & (2|4) = 0
				AND (
 					q.number IS NULL		-- if no join rows assume it is offline by default, set offline time to 0 (epoch)
 					OR q.number = 1
				)
	END
 	IF (@opType = 1)
 	BEGIN
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				-- ignore inputed days, only want to know if client offline NOW!
 				t.isOnline = 0
 				AND t.clientId > 1
 	END
 	ELSE IF (@opType = 2)
 	BEGIN
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				-- ignore inputed days, only want to know if client online NOW!
 				t.isOnline = 1
 				AND t.clientId > 1
 	END
 	ELSE IF (@opType = 3)
 	BEGIN	-- get clients that have been offlines > N days
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND @offlineAtCheck > t.lastOfflineTime
 				AND t.isOnline = 0
 				AND (
 					t.daysOffline >= @compValue
 					OR t.daysOffline = -1			-- never been online or offline  - reported as offline
 				)
 	END
 	ELSE IF (@opType = 4)
 	BEGIN	-- get clients that have been offlines >= N days
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND @offlineAtCheck > t.lastOfflineTime
 				AND t.isOnline = 0
 				AND (
 					t.daysOffline >= @compValue
 					OR t.daysOffline = -1			-- never been online or offline  - reported as offline
 				)
 	END
 	ELSE IF (@opType = 5)
 	BEGIN	-- client is currently offline or was offline at least once during this period
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND (
 					@offlineAtCheck < t.lastOfflineTime
 					OR t.isOnline = 0		-- must be offline
 				)
 	END
 	ELSE IF (@opType = 6)
 	BEGIN	-- client is currently offline or was offline at least once during this period
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND (
 					@offlineAtCheck <= t.lastOfflineTime
 					OR t.isOnline = 0		-- must be offline
 				)
 	END
 	ELSE IF (@opType = 7)
 	BEGIN	-- get clients that went offline between these times
 		IF (@offlineAtCheck < @offlineAtCheck2)
 		BEGIN
 			SET @day1 = @offlineAtCheck
 			SET @day2 = @offlineAtCheck2
 		END
 		ELSE
 		BEGIN
 			SET @day1 = @offlineAtCheck2
 			SET @day2 = @offlineAtCheck
 		END
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND t.lastOfflineTime BETWEEN @day1 AND @day2
 	END
 	ELSE IF (@opType = 8)
 	BEGIN	-- get clients that wend offline before or after these times
 		IF (@offlineAtCheck < @offlineAtCheck2)
 		BEGIN
 			SET @day1 = @offlineAtCheck
 			SET @day2 = @offlineAtCheck2
 		END
 		ELSE
 		BEGIN
 			SET @day1 = @offlineAtCheck2
 			SET @day2 = @offlineAtCheck
 		END
 		INSERT INTO @clientIds
 			SELECT DISTINCT
 				t.clientId
 			FROM @list t
 			WHERE
 				t.clientId > 1
 				AND t.lastOfflineTime NOT BETWEEN @day1 AND @day2
 	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientOfflineDays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientOfflineDays' AND revision = '1.1.2.9')

  insert into GXDBVersions values(5, 'scgV2GetClientOfflineDays',  '1.1.2.9', 'scgV2GetClientOfflineDays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
