

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientOSVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientOSVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientOSVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientOSVersion]
  delete from GXDBVersions where name = 'scgV2GetClientOSVersion' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientOSVersion(@operator VARCHAR(24), @compValue NVARCHAR(1024), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.osName = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.osName <> @compValue
		END ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.osName LIKE @compValue  ESCAPE('\')
		END ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId > 1
					AND c.osName NOT LIKE @compValue  ESCAPE('\')
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.osName = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.osName <> @compValue
		END ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.osName LIKE @compValue  ESCAPE('\')
		END ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM ClientOSNameView c WITH(READUNCOMMITTED)
				WHERE
					c.clientId = @inClientId
					AND c.osName NOT LIKE @compValue  ESCAPE('\')
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientOSVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientOSVersion' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2GetClientOSVersion',  '1.1.2.5', 'scgV2GetClientOSVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
