

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientOSType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientOSType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientOSType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientOSType]
  delete from GXDBVersions where name = 'scgV2GetClientOSType' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientOSType(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
						c.simOperatingSystemId = os.id
				WHERE
					c.id > 1
					AND @compValue = CASE
										WHEN os.type = 'Windows' THEN 1
										WHEN os.type = 'Unix' THEN 2
										ELSE 0 -- Other OS
									END
		END
		ELSE IF (@opType = 2)	-- UNIX
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
						c.simOperatingSystemId = os.id
				WHERE
					c.id > 1
					AND @compValue <> CASE
										WHEN os.type = 'Windows' THEN 1
										WHEN os.type = 'Unix' THEN 2
										ELSE 0 -- Other OS
									END
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
						c.simOperatingSystemId = os.id
				WHERE
					c.id = @inClientId
					AND @compValue = CASE
										WHEN os.type = 'Windows' THEN 1
										WHEN os.type = 'Unix' THEN 2
										ELSE 0 -- Other OS
									END
		END
		ELSE IF (@opType = 2)	-- UNIX
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
						c.simOperatingSystemId = os.id
				WHERE
					c.id = @inClientId
					AND @compValue <> CASE
										WHEN os.type = 'Windows' THEN 1
										WHEN os.type = 'Unix' THEN 2
										ELSE 0 -- Other OS
									END
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientOSType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientOSType' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2GetClientOSType',  '1.1.2.5', 'scgV2GetClientOSType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
