

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientOSName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientOSName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientOSName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientOSName]
  delete from GXDBVersions where name = 'scgV2GetClientOSName' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientOSName(@operator VARCHAR(24), @compValue NVARCHAR(1024), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id > 1
					AND cp.attrVal = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id > 1
					AND (
						cp.attrVal IS NULL
						OR cp.attrVal = @compValue
					)
		END ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id > 1
					AND cp.attrVal LIKE @compValue ESCAPE('\')
		END ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id > 1
					AND (
						cp.attrVal IS NULL
						OR cp.attrVal NOT LIKE @compValue  ESCAPE('\')
					)
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id = @inClientId
					AND cp.attrVal = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id = @inClientId
					AND (
						cp.attrVal IS NULL
						OR cp.attrVal = @compValue
					)
		END ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id = @inClientId
					AND cp.attrVal LIKE @compValue ESCAPE('\')
		END ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					LEFT OUTER JOIN APP_ClientProp cp  WITH(READUNCOMMITTED) ON
						cp.attrName='Sim OS Info'
						AND cp.modified = 0
				WHERE
					c.id = @inClientId
					AND (
						cp.attrVal IS NULL
						OR cp.attrVal NOT LIKE @compValue  ESCAPE('\')
					)
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientOSName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientOSName' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2GetClientOSName',  '1.1.2.5', 'scgV2GetClientOSName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
