

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientOSInfoList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientOSInfoList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientOSInfoList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientOSInfoList]
  delete from GXDBVersions where name = 'scgV2GetClientOSInfoList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientOSInfoList(@operator VARCHAR(24), @compValue XML, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
  BEGIN
         DECLARE @opType INT= 0;
         SELECT @opType = CASE @operator
                              WHEN '='         THEN 1
                              WHEN '!='        THEN 2
                              WHEN '<>'        THEN 2
                              ELSE 0
                          END
         IF(@opType = 0)
             BEGIN
                 RETURN;
         END
         DECLARE @OSInputList TABLE
         (OSID INT PRIMARY KEY)
         INSERT INTO @OSInputList(OSID)
                SELECT cg.value('@val', 'int')
                FROM @compValue.nodes('/App_SCGRuleValueList/id') l(cg);
	    DECLARE @rcnt INT= @@ROWCOUNT
         IF(@rcnt = 0)
             BEGIN
		--QUIT
                 RETURN;
		   END
         DECLARE @XmlInfo XML;
         SELECT @XmlInfo = CAST(Value AS XML)
         FROM GxGlobalParam WITH (READUNCOMMITTED)
         WHERE Name = 'SCGGetOSVersionInfoEnumXML';
		--select @XmlInfo
         DECLARE @OSNamesList TABLE
         (ID     INT PRIMARY KEY,
          OSname NVARCHAR(4000)
         )
         INSERT INTO @OSNamesList
         (ID,
          OSName
         )
                SELECT t.c.value('(@OSID[1])', 'int'),
                       t.c.value('(@OSName[1])', 'NVARCHAR(MAX)')
                FROM @XmlInfo.nodes('OS_Info/OSList') AS T(C);
         IF(@inClientId = 0)
             BEGIN
		-- All Clients
                 IF(@opType = 1)
                     BEGIN
                         INSERT INTO @clientIds
                                SELECT c.ID
                                FROM  App_Client C WITH (READUNCOMMITTED)
									 INNER JOIN App_ClientProp ac WITH (READUNCOMMITTED) ON c.ID=Ac.ComponentNameID
								     INNER JOIN @OSNamesList Ol ON Ac.Attrval = Ol.Osname
                                     INNER JOIN @OSInputList Os ON Os.OsID = Ol.id
                                WHERE Ac.modified = 0
                                      AND Ac.attrName = N'Operating System Name'
                                      AND c.ID > 1
									  AND (C.status & (2|4)) = 0
                 END;
                     ELSE
                 IF(@opType = 2)
                     BEGIN
                         INSERT INTO @clientIds
                                SELECT c.id
                                FROM APP_Client c WITH (READUNCOMMITTED)
                                WHERE c.id > 1 AND   (C.status & (2|4)) = 0
                                EXCEPT
                                SELECT ac.ComponentNameID
                                FROM App_ClientProp ac WITH (READUNCOMMITTED)
                                     INNER JOIN @OSNamesList Ol ON Ac.Attrval = Ol.Osname
                                     INNER JOIN @OSInputList Os ON Os.OsID = Ol.id
                                WHERE Ac.modified = 0
                                      AND Ac.attrName = N'Operating System Name'
                 END;
         END;
             ELSE
             BEGIN
		-- Given client
                 IF(@opType = 1)
                     BEGIN
                         INSERT INTO @clientIds
                                SELECT c.ID
                                FROM  App_Client C WITH (READUNCOMMITTED)
									 INNER JOIN App_ClientProp ac WITH (READUNCOMMITTED) ON c.ID=Ac.ComponentNameID
                                     INNER JOIN @OSNamesList Ol ON Ac.Attrval = Ol.Osname
                                     INNER JOIN @OSInputList Os ON Os.OsID = Ol.id
                                WHERE Ac.modified = 0
                                      AND Ac.attrName = N'Operating System Name'
                                      AND c.ID > 1
                                      AND c.ID = @inClientId
									  AND (C.status & (2|4)) = 0
                 END;
                     ELSE
                 IF(@opType = 2)
                     BEGIN
                         INSERT INTO @clientIds
                                SELECT c.id clientId
                                FROM APP_Client c WITH (READUNCOMMITTED)
                                WHERE c.id = @inClientId
									 AND c.id > 1 AND (C.status & (2|4)) = 0
                                EXCEPT
                                SELECT ac.ComponentNameID
                                FROM App_ClientProp ac WITH (READUNCOMMITTED)
                                     INNER JOIN @OSNamesList Ol ON Ac.Attrval = Ol.Osname
                                     INNER JOIN @OSInputList Os ON Os.OsID = Ol.id
                                WHERE Ac.modified = 0
                                      AND Ac.attrName = N'Operating System Name'
                                      AND ac.ComponentNameID = @inClientId;
                 END;
         END;
         RETURN;
     END;


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientOSInfoList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientOSInfoList' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'scgV2GetClientOSInfoList',  '1.1.2.2', 'scgV2GetClientOSInfoList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
