

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientListWithCIDRMask.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientListWithCIDRMask'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientListWithCIDRMask]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientListWithCIDRMask]
  delete from GXDBVersions where name = 'scgV2GetClientListWithCIDRMask' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientListWithCIDRMask(@operator VARCHAR(24), @compValue varchar(18), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
    DECLARE @InValidIP TINYINT= 1
	SELECT @opType = CASE @operator
                    WHEN '='		THEN 1
                    WHEN '<>'		THEN 2
                END
    IF @compValue LIKE '%_.%_.%_.%_,%'
        AND @compValue NOT LIKE '%.%.%.%.%'
        AND @compValue NOT LIKE '%[^0-9.,]%'
        AND @compValue NOT LIKE '%[0-9][0-9][0-9][0-9]%'
        AND @compValue NOT LIKE '%[3-9][0-9][0-9]%'
        AND @compValue NOT LIKE '%2[6-9][0-9]%'
        AND @compValue NOT LIKE '%25[6-9]%'
        AND @compValue NOT LIKE '%,[3-9][3-9]%'
        AND @compValue NOT LIKE '%[a-z]%'
        AND CHARINDEX('%',@compValue) =0
	BEGIN
        SET @InValidIP=0                                -- Set 0 for Valid Ip
	END
	IF (@opType = 0 or @InValidIP > 0)
	BEGIN
		RETURN
	END
	DECLARE @Mask INT;
	DECLARE @Base BIGINT= 4294967295;					--2^32
	DECLARE @Power BIGINT;
	DECLARE @LowRangeIP BIGINT;
	DECLARE @HighRangeIP BIGINT;
	DECLARE @IPAddress VARCHAR(15);
    DECLARE @IPAddressDecimal BIGINT
DECLARE @IPAddressesPropertyTypeId INT = 2102		-- CV_COMPONENT_CLIENT_IP_ADDRESSES defined in appMgrComponentDefines.h
	SELECT @IPAddress = LEFT(@compValue, CHARINDEX(',', @compValue)-1);
	SELECT @mask = CAST(RIGHT(@compValue, CHARINDEX(',', REVERSE(@compValue))-1) AS INT);
	SELECT @Power = POWER(2.0, 32.0 - @Mask) - 1;						  --(Hosts-1)
    SELECT @IPAddressDecimal=	  CONVERT(BIGINT, PARSENAME(@IPAddress, 1)) +
                                CONVERT(BIGINT, PARSENAME(@IPAddress, 2)) * 256 +
                                CONVERT(BIGINT, PARSENAME(@IPAddress, 3)) * 65536 +
                                CONVERT(BIGINT, PARSENAME(@IPAddress, 4)) * 16777216
	SELECT @LowRangeIP =  @IPAddressDecimal&(@Base^@Power);
	SELECT @HighRangeIP = @LowRangeIP + @Power;
    DECLARE  @IPAddressList TABLE(
        ClientID int,
        IpAddress  varchar(15),
        IpAddressDecimal BIGINT  DEFAULT 0
        PRIMARY KEY (ClientID,IpAddressDecimal)
	)
	DECLARE @rcnt INT = 0
	IF (@inClientId = 0)
	BEGIN
		INSERT INTO @IPAddressList
			SELECT DISTINCT
				IPList.cid,
				IPList.ip,
				(CONVERT(BIGINT, PARSENAME(IPList.ip, 1))
				+ CONVERT(BIGINT, PARSENAME(IPList.ip, 2)) * 256
				+ CONVERT(BIGINT, PARSENAME(IPList.ip, 3)) * 65536
				+ CONVERT(BIGINT, PARSENAME(IPList.ip, 4)) * 16777216) AS IP_Decimal
			FROM
				(
					SELECT
						ComponentID Cid,
						LTRIM(RTRIM(S.Data))  IP			  --IP
					FROM APP_ComponentProp(NOLOCK) C
						CROSS APPLY dbo.SplitString(C.stringVal, ',') S
					WHERE C.propertyTypeId = @IPAddressesPropertyTypeId
						AND C.modified = 0
						AND S.Data NOT LIKE '%:%'		-- discard IPv6 Addresses
				) IPList
			WHERE
				IPList.ip IS NOT NULL
				AND IPList.ip LIKE '%.%.%.%'  --IPV4 Only Valid Addresses
		SET @rcnt = @@ROWCOUNT
	END
	ELSE
	BEGIN
		-- Given client
		INSERT INTO @IPAddressList
			SELECT DISTINCT
				IPList.cid,
				IPList.ip,
				(CONVERT(BIGINT, PARSENAME(IPList.ip, 1))
				+ CONVERT(BIGINT, PARSENAME(IPList.ip, 2)) * 256
				+ CONVERT(BIGINT, PARSENAME(IPList.ip, 3)) * 65536
				+ CONVERT(BIGINT, PARSENAME(IPList.ip, 4)) * 16777216) AS IP_Decimal
			FROM
				(
					SELECT
						ComponentID Cid,
						LTRIM(RTRIM(S.Data))  IP			  --IP
					FROM APP_ComponentProp(NOLOCK) C
						CROSS APPLY dbo.SplitString(C.stringVal, ',') S
					WHERE C.propertyTypeId = @IPAddressesPropertyTypeId
						AND C.modified = 0
						AND S.Data NOT LIKE '%:%'		-- discard IPv6 Valid Addresses
						AND C.componentId = @inClientId
				) IPList
			WHERE
				IPList.ip IS NOT NULL
				AND IPList.ip LIKE '%.%.%.%'  --IPV4 Only Addresses
			SET @rcnt = @@ROWCOUNT
	END
	IF (@rcnt = 0)
	BEGIN
		RETURN
	END
	IF (@opType = 1)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				ClientID
			FROM @IPAddressList
			WHERE
				IpAddressDecimal > @LowRangeIP
				AND IpAddressDecimal < @HighRangeIP
	END ELSE
	IF (@opType = 2)
	BEGIN
		INSERT INTO @clientIds
		SELECT DISTINCT
			ClientID
		FROM @IPAddressList
		EXCEPT
		SELECT
			ClientID
		FROM @IPAddressList
		WHERE
			IpAddressDecimal > @LowRangeIP
			AND IpAddressDecimal < @HighRangeIP
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientListWithCIDRMask]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientListWithCIDRMask' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'scgV2GetClientListWithCIDRMask',  '1.1.2.7', 'scgV2GetClientListWithCIDRMask', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
