

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientDisplayName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientDisplayName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientDisplayName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientDisplayName]
  delete from GXDBVersions where name = 'scgV2GetClientDisplayName' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientDisplayName(@operator VARCHAR(16), @compValue NVARCHAR(256), @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN 'LIKE' THEN 3
							WHEN 'NOT LIKE' THEN 4
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName = @compValue
					AND c.id > 1
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName LIKE @compValue ESCAPE('\')
					AND c.id > 1
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName <> @compValue
					AND c.id > 1
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName NOT LIKE @compValue ESCAPE('\')
					AND c.id > 1
		END
		--ELSE empty table returned
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName = @compValue
					AND c.id = @inClientId
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName LIKE @compValue ESCAPE('\')
					AND c.id = @inClientId
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName <> @compValue
					AND c.id = @inClientId
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM
					APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.displayName NOT LIKE @compValue ESCAPE('\')
					AND c.id = @inClientId
		END
		--ELSE empty table returned
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientDisplayName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientDisplayName' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'scgV2GetClientDisplayName',  '1.1.2.1', 'scgV2GetClientDisplayName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
