

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientByRole.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientByRole'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientByRole]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientByRole]
  delete from GXDBVersions where name = 'scgV2GetClientByRole' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientByRole(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMRoles r WITH(NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE r.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMRoles r WITH (NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE r.id = @compValue)
			BEGIN
				-- All Clients
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(NOLOCK)
					WHERE c.id > 1
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
					WHERE
						r.id = @compValue
						AND sa.entityId1 > 1
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						r.id = @compValue
						AND cga.clientId > 1
			END
		END
		ELSE IF (@opType = 2)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMRoles r WITH(NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE r.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMRoles r WITH (NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE r.id = @compValue)
			BEGIN
				-- No Clients
				RETURN
			END
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(NOLOCK)
				WHERE c.id > 1
				EXCEPT
				SELECT
					t.clientId
				FROM (
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
					WHERE
						r.id = @compValue
						AND sa.entityId1 > 1
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						r.id = @compValue
						AND cga.clientId > 1
				) t
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMRoles r WITH(NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE r.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMRoles r WITH (NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE r.id = @compValue)
			BEGIN
				-- All Clients
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(NOLOCK)
					WHERE c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
					WHERE
						r.id = @compValue
						AND sa.entityId1  = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						r.id = @compValue
						AND cga.clientId  = @inClientId
			END
		END
		ELSE IF (@opType = 2)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMRoles r WITH(NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE r.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMRoles r WITH (NOLOCK) ON r.id <> 0 AND r.id = sa.roleId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE r.id = @compValue)
			BEGIN
				-- No Clients
				RETURN
			END
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(NOLOCK)
				WHERE c.id  = @inClientId
				EXCEPT
				SELECT
					t.clientId
				FROM (
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
					WHERE
						r.id = @compValue
						AND sa.entityId1  = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRoles r WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND r.id = sa.roleId
							AND r.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						r.id = @compValue
						AND cga.clientId  = @inClientId
				) t
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientByRole]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientByRole' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2GetClientByRole',  '1.1.2.4', 'scgV2GetClientByRole', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
