

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2GetClientByPermission.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2GetClientByPermission'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2GetClientByPermission]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2GetClientByPermission]
  delete from GXDBVersions where name = 'scgV2GetClientByPermission' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2GetClientByPermission(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMPermissions p WITH(NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE p.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMPermissions p WITH (NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE p.id = @compValue)
			BEGIN
				-- All Clients
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(NOLOCK)
					WHERE c.id > 1
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 > 1
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 > 1
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId > 1
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId > 1
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId > 1
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
			END
		END
		ELSE IF (@opType = 2)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMPermissions p WITH(NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE p.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMPermissions p WITH (NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE p.id = @compValue)
			BEGIN
				-- No Clients
				RETURN
			END
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(NOLOCK)
				WHERE c.id > 1
				EXCEPT
				SELECT
					t.clientId
				FROM (
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 > 1
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 > 1
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId > 1
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId > 1
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId > 1
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId > 1
				) t
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMPermissions p WITH(NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE p.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMPermissions p WITH (NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE p.id = @compValue)
			BEGIN
				-- All Clients
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(NOLOCK)
					WHERE c.id = @inClientId
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
			END
		END
		ELSE IF (@opType = 2)
		BEGIN
			IF EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH(NOLOCK) INNER JOIN UMPermissions p WITH(NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 = 1 AND sa.entityId1 = 2 WHERE p.id = @compValue)
				OR EXISTS (SELECT TOP 1 1 FROM UMSecurityAssociations sa WITH (NOLOCK) INNER JOIN UMPermissions p WITH (NOLOCK) ON p.id <> 0 AND p.id = sa.permissionId AND sa.entityType1 IN (3, 28) AND sa.includeAll = 1 WHERE p.id = @compValue)
			BEGIN
				-- No Clients
				RETURN
			END
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(NOLOCK)
				WHERE c.id = @inClientId
				EXCEPT
				SELECT
					t.clientId
				FROM (
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = sa.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						sa.entityId1 clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 3		-- CLIENT_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND sa.entityId1 = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMSecurityAssociations sa WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							r.roleId = sa.roleId
							AND r.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							sa.entityType1 = 28		-- CLIENT_GROUP_ENTITY
							AND p.id = r.permissionId
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR sa.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = sa.entityId1
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = ro.permissionId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND p.id <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 3		-- CLIENT_ENTITY
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 28		-- CLIENT_GROUP_ENTITY
							AND ro.roleId <> 0
							AND (
								@inSCGId = 0
								OR ro.entityId <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
							)
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
					UNION
					SELECT
						ro.entityId clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
					WHERE
						p.id = @compValue
						AND ro.entityId = @inClientId
					UNION
					SELECT
						cga.clientId
					FROM UMOwnerRoles ro WITH(NOLOCK)
						INNER JOIN UMRolesWithPermissionsExpanded r WITH(NOLOCK) ON
							ro.roleId = r.roleId
							AND ro.entityType = 1		-- commcell level
							AND ro.entityId = 2
							AND ro.roleId <> 0
						INNER JOIN UMPermissions p WITH(NOLOCK) ON
							p.id = r.permissionId
							AND p.id <> 0
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = ro.entityId
					WHERE
						p.id = @compValue
						AND cga.clientId = @inClientId
				) t
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2GetClientByPermission]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2GetClientByPermission' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2GetClientByPermission',  '1.1.2.4', 'scgV2GetClientByPermission', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
