

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2DaysSinceLastBkpForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2DaysSinceLastBkpForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2DaysSinceLastBkpForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2DaysSinceLastBkpForClient]
  delete from GXDBVersions where name = 'scgV2DaysSinceLastBkpForClient' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2DaysSinceLastBkpForClient(@operator VARCHAR(24), @compValue INT, @secCompValue INT, @inClientId INT,@inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
		DECLARE @opType INT = 0
		SELECT 	@opType = CASE @operator
								WHEN '=' THEN 1
								WHEN '!=' THEN 2
								WHEN '<>' THEN 2
								WHEN '>' THEN 3
								WHEN '>=' THEN 4
								WHEN '<' THEN 5
								WHEN '<=' THEN 6
								WHEN 'BETWEEN' THEN 7
								WHEN 'NOT BETWEEN' THEN 8
								ELSE 0
							END
		IF (@opType = 0)
		BEGIN
			RETURN
		END
		DECLARE @now	INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @list TABLE (
			clientId		INT PRIMARY KEY,
			lastBackedup	BIGINT
		)
		DECLARE @vmBackups TABLE (
			vmClientId		INT PRIMARY KEY,
			lastBackedup	BIGINT
		)
		IF (@inClientId = 0)
		BEGIN
			INSERT INTO @list
				SELECT
					app.ClientID,
					ISNULL(MAX(CAST(scp.attrVal AS BIGINT)), 0)		-- set 0 if never backed up
				FROM App_Application app (NOLOCK)
					LEFT JOIN App_SubclientProp scp WITH(NOLOCK) ON
						App.id = scp.componentNameId
						AND scp.attrName = N'Last Data Protected Time'
						AND scp.modified = 0
						AND scp.cs_attrName = CHECKSUM(N'Last Data Protected Time')
						AND dbo.IsSubClientValid(app.appTypeId, app.subclientStatus, 0) = 1		--RBAR!!!!
				GROUP BY app.clientid
			-- Get VM backup times
			INSERT INTO @vmBackups
				SELECT
					cp2.componentNameId,
					CAST(cp2.attrVal AS BIGINT) LastBackedUp
				FROM APP_ClientProp cp WITH(NOLOCK)
					INNER JOIN APP_ClientProp cp2 WITH(NOLOCK) ON
							cp.attrName = N'Last Backup JobID' AND cp.modified = 0
							AND cp.componentNameId = cp2.componentNameId
							AND cp2.attrName = N'Last VM Backup Start Time' AND cp2.modified = 0 -- Different in SP18+ vs earlier SP using N'vmBackupStartTime'
			-- insert new vm client rows
			INSERT INTO @list
				SELECT
					b.vmClientId,
					b.lastBackedup
				FROM @vmBackups b
					LEFT OUTER JOIN @list l ON
						l.clientId = b.vmClientId
				WHERE
					l.clientId IS NULL		-- make sure client row not already present
			-- update client rows if newer backup as vm
			UPDATE l
				SET LastBackedup = b.lastBackedup
			FROM  @list l
				INNER JOIN @vmBackups b ON
					b.vmClientId = l.clientId
			WHERE
				l.lastBackedup < b.lastBackedup		-- want the last backup taken
		END
		ELSE
		BEGIN
			INSERT INTO @list
				SELECT
					app.ClientID,
					ISNULL(MAX(CAST(scp.attrVal AS BIGINT)), 0)		-- set 0 if never backed up
				FROM App_Application app (NOLOCK)
					LEFT JOIN App_SubclientProp scp WITH(NOLOCK) ON
						app.id = scp.componentNameId
						AND scp.attrName = N'Last Data Protected Time'
						AND scp.modified = 0
						AND scp.cs_attrName = CHECKSUM(N'Last Data Protected Time')
						AND dbo.IsSubClientValid(app.appTypeId, app.subclientStatus, 0) = 1		--RBAR!!!!
				WHERE
					app.clientId = @inClientId
				GROUP BY app.clientid
			-- Get VM backup times
			INSERT INTO @vmBackups
				SELECT
					cp2.componentNameId,
					CAST(cp2.attrVal AS BIGINT) LastBackedUp
				FROM APP_ClientProp cp WITH(NOLOCK)
					INNER JOIN APP_ClientProp cp2 WITH(NOLOCK) ON
							cp.attrName = N'Last Backup JobID' AND cp.modified = 0
							AND cp.componentNameId = cp2.componentNameId
							AND cp2.attrName = N'Last VM Backup Start Time' AND cp2.modified = 0 -- Different in SP18+ vs earlier SP using N'vmBackupStartTime'
				WHERE cp.componentNameId = @inClientId
			-- insert new vm client rows
			INSERT INTO @list
				SELECT
					b.vmClientId,
					b.lastBackedup
				FROM @vmBackups b
					LEFT OUTER JOIN @list l ON
						l.clientId = b.vmClientId
				WHERE
					l.clientId IS NULL		-- make sure client row not already present
					AND b.vmClientId = @inClientId
			-- update client rows if newer backup as vm
			UPDATE l
				SET LastBackedup = b.lastBackedup
			FROM  @list l
				INNER JOIN @vmBackups b ON
					b.vmClientId = l.clientId
			WHERE
				l.lastBackedup < b.lastBackedup		-- want the last backup taken
				AND l.clientId = @inClientId
		END
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) = @compValue
		END
		ELSE IF (@opType = 2)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) <> @compValue
		END
		ELSE IF (@opType = 3)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) > @compValue
		END
		ELSE IF (@opType = 4)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) >= @compValue
		END
		ELSE IF (@opType = 5)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) < @compValue
		END
		ELSE IF (@opType = 6)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) <= @compValue
		END
		ELSE IF (@opType = 7)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) BETWEEN  @compValue AND @secCompValue
		END
		ELSE IF (@opType = 8)
		BEGIN
			INSERT INTO @clientIds
				SELECT  ClientID
				FROM @List
				WHERE
					CAST(ROUND(((@now - (LastBackedup)) / 86400),0) as INT) NOT BETWEEN  @compValue AND @secCompValue
		END
		RETURN
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2DaysSinceLastBkpForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2DaysSinceLastBkpForClient' AND revision = '1.1.2.9')

  insert into GXDBVersions values(5, 'scgV2DaysSinceLastBkpForClient',  '1.1.2.9', 'scgV2DaysSinceLastBkpForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
