

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2DaysSinceClientCreated.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2DaysSinceClientCreated'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2DaysSinceClientCreated]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2DaysSinceClientCreated]
  delete from GXDBVersions where name = 'scgV2DaysSinceClientCreated' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2DaysSinceClientCreated(@operator VARCHAR(24), @compValue INT, @secCompValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
---- WITH ENCRYPTION
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							WHEN '>' THEN 3
							WHEN '>=' THEN 4
							WHEN '<' THEN 5
							WHEN '<=' THEN 6
							WHEN 'BETWEEN' THEN 7
							WHEN 'NOT BETWEEN' THEN 8
							ELSE 0
						END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @now	INT = dbo.GetUnixTime(GetUTCDate())
	DECLARE @list TABLE (
		clientId	INT,
		createdDays	INT,
		PRIMARY KEY(createdDays, clientId)
	)
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		INSERT INTO @list
			SELECT DISTINCT
				q.clientId,
				CASE
					WHEN q.refTime IS NULL THEN 2147483647
					WHEN q.refTime = 0 THEN 2147483647
					ELSE CAST(ROUND((@now - q.refTime) / 86400.00,0) as INT)	--(24*3600)
				END createdDays
			FROM (
				SELECT
					c.id clientId,
					CASE
						WHEN c.refTime = 0 THEN dbo.GetUnixTime((SELECT MIN(OpTime) FROM simInstalledPackagesHistory iph WITH(READUNCOMMITTED) WHERE iph.ClientId = c.id))
						ELSE c.refTime
					END refTime
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1) q
	END
	ELSE
	BEGIN
		-- Given client
		INSERT INTO @list
			SELECT DISTINCT
				q.clientId,
				CASE
					WHEN q.refTime IS NULL THEN 2147483647
					WHEN q.refTime = 0 THEN 2147483647
					ELSE CAST(ROUND((@now - q.refTime) / 86400.00,0) as INT)	--(24*3600)
				END createdDays
			FROM (
				SELECT
					c.id clientId,
					CASE
						WHEN c.refTime = 0 THEN dbo.GetUnixTime((SELECT MIN(OpTime) FROM simInstalledPackagesHistory iph WITH(READUNCOMMITTED) WHERE iph.ClientId = c.id))
						ELSE c.refTime
					END refTime
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId) q
	END
	IF (@opType = 1)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays = @compValue
	END
	ELSE IF (@opType = 2)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays <> @compValue
	END
	ELSE IF (@opType = 3)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays > @compValue
	END
	ELSE IF (@opType = 4)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays >= @compValue
	END
	ELSE IF (@opType = 5)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays < @compValue
	END
	ELSE IF (@opType = 6)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays <= @compValue
	END
	ELSE IF (@opType = 7)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays BETWEEN @compValue AND @secCompValue
	END
	ELSE IF (@opType = 8)
	BEGIN
		INSERT INTO @clientIds
			SELECT DISTINCT
				t.clientId
			FROM @list t
			WHERE
				t.createdDays NOT BETWEEN @compValue AND @secCompValue
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2DaysSinceClientCreated]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2DaysSinceClientCreated' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'scgV2DaysSinceClientCreated',  '1.1.2.7', 'scgV2DaysSinceClientCreated', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
