

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2CompareAppTypes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2CompareAppTypes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2CompareAppTypes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2CompareAppTypes]
  delete from GXDBVersions where name = 'scgV2CompareAppTypes' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2CompareAppTypes(@operator varchar(16), @Agents XML, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @AppTypes TABLE (
		appTypeId INT PRIMARY KEY
	)
	INSERT INTO @AppTypes
		SELECT ref.value('@appTypeId' , 'INT') appTypeId FROM @Agents.nodes('TMMsg_AppGroupSelection/appTypes') R(ref)
		UNION
		SELECT
			at.appTypeId
		FROM APP_AppTypeGroupAssoc at WITH(NOLOCK)
			INNER JOIN (SELECT ref.value('@appGroupId' , 'INT') appGroupId FROM @Agents.nodes('TMMsg_AppGroupSelection/appGroups') R(ref)) ag ON
				at.appGroupId = ag.appGroupId
				AND at.typeOfGroup = 0
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_IDAName n WITH(READUNCOMMITTED) ON
						n.clientId = c.id
					INNER JOIN @AppTypes at ON
						at.appTypeId = n.appTypeId
				WHERE
					c.id > 1
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_IDAName n WITH(READUNCOMMITTED) ON
						n.clientId = c.id
					INNER JOIN @AppTypes at ON
						at.appTypeId = n.appTypeId
				WHERE
					c.id > 1
		END
	END
	ELSE
	BEGIN
		-- Given client
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_IDAName n WITH(READUNCOMMITTED) ON
						n.clientId = c.id
					INNER JOIN @AppTypes at ON
						at.appTypeId = n.appTypeId
				WHERE
					c.id = @inClientId
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientId
				EXCEPT
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
					INNER JOIN APP_IDAName n WITH(READUNCOMMITTED) ON
						n.clientId = c.id
					INNER JOIN @AppTypes at ON
						at.appTypeId = n.appTypeId
				WHERE
					c.id = @inClientId
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2CompareAppTypes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2CompareAppTypes' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'scgV2CompareAppTypes',  '1.1.2.5', 'scgV2CompareAppTypes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
