

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2CompanyClientInstallAssociations.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2CompanyClientInstallAssociations'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2CompanyClientInstallAssociations]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2CompanyClientInstallAssociations]
  delete from GXDBVersions where name = 'scgV2CompanyClientInstallAssociations' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2CompanyClientInstallAssociations(@operator VARCHAR(16),  @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @InCompanies TABLE (
		id		INT PRIMARY KEY
	)
	IF (@opType = 1)
	BEGIN
		INSERT INTO @InCompanies(id)
			SELECT
				id
			FROM UMDSProviders p WITH(NOLOCK)
			WHERE
				p.id = @compValue
				AND p.serviceType = 5	-- UMDS_PROVIDER_ORGANIZATIONS
	END
	ELSE IF (@opType = 2)
	BEGIN
		INSERT INTO @InCompanies(id)
			SELECT
				id
			FROM UMDSProviders p WITH(NOLOCK)
			WHERE
				p.id <> @compValue
				AND p.serviceType = 5	-- UMDS_PROVIDER_ORGANIZATIONS
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		INSERT INTO @clientIds
			SELECT DISTINCT ACP.componentNameId FROM APP_ClientProp ACP  WITH(NOLOCK)
				INNER JOIN @InCompanies Comp
					ON ACP.attrVal = CAST(Comp.id AS NVARCHAR(12))
WHERE ACP.attrName='Installation Company ID'
				AND ACP.modified=0
	END
	ELSE
	BEGIN
		-- Given client
		INSERT INTO @clientIds
			SELECT DISTINCT ACP.componentNameId FROM APP_ClientProp ACP  WITH(NOLOCK)
				INNER JOIN @InCompanies Comp
					ON ACP.attrVal = CAST(Comp.id AS NVARCHAR(12))
WHERE ACP.attrName='Installation Company ID'
				AND ACP.modified=0
				AND ACP.componentNameId = @inClientId
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2CompanyClientInstallAssociations]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2CompanyClientInstallAssociations' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2CompanyClientInstallAssociations',  '1.1.2.4', 'scgV2CompanyClientInstallAssociations', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
