

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2CompanyClientAssociations.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: scgV2CompanyClientAssociations'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2CompanyClientAssociations]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2CompanyClientAssociations]
  delete from GXDBVersions where name = 'scgV2CompanyClientAssociations' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2CompanyClientAssociations(@operator VARCHAR(16),  @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @InCompanies TABLE (
		id		INT PRIMARY KEY
	)
	IF (@opType = 1)
	BEGIN
		INSERT INTO @InCompanies(id)
			SELECT
				id
			FROM UMDSProviders p WITH(NOLOCK)
			WHERE
				p.id = @compValue
AND p.serviceType = 5
	END
	ELSE IF (@opType = 2)
	BEGIN
		INSERT INTO @InCompanies(id)
			SELECT
				id
			FROM UMDSProviders p WITH(NOLOCK)
			WHERE
				p.id <> @compValue
AND p.serviceType = 5
	END
	;WITH CompanyOwners(companyId, ownerId) AS
	(	-- recursion
		SELECT
			p.id,
			p.ownerCompany
		FROM UMDSProviders p WITH(NOLOCK)
			INNER JOIN @InCompanies ic ON
				p.id = ic.id
AND p.serviceType = 5
		UNION ALL
		SELECT
			p.id,
			p.ownerCompany
		FROM UMDSProviders p WITH(NOLOCK)
			INNER JOIN CompanyOwners c ON
				p.ownerCompany = c.companyId
AND p.serviceType = 5
	)
		INSERT INTO @InCompanies(id)
			SELECT DISTINCT
				companyId
			FROM CompanyOwners co
				LEFT OUTER JOIN @InCompanies c ON
					c.id = co.companyId
			WHERE
				co.companyId > 0
				AND c.id IS NULL
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		;WITH Providers(companyId) AS
		(
			SELECT
				c.id
			FROM  @InCompanies c
			UNION
			SELECT
				p.id
			FROM UMDSProviders p WITH(NOLOCK)
				INNER JOIN @InCompanies c ON
					c.id = p.ownerCompany
AND p.serviceType IN (2,12)
		)
		,Users(userId) AS (
			SELECT DISTINCT
				u.id
			FROM Providers c
				INNER JOIN UMUsers u WITH(NOLOCK) ON
					u.umDSproviderId = c.companyId
					AND (u.flags & 1) <> 0
		)
		,Groups(groupId) AS (
			SELECT DISTINCT
				g.id groupId
			FROM Providers c
				INNER JOIN UMGroups g WITH(NOLOCK) ON
					g.umdsProviderId = c.companyId
		)
			INSERT INTO @clientIds
				SELECT
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Users u WITH(NOLOCK) ON
						a.entityType1 = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
				LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
a.entityId1 > 1 AND (a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
				UNION
				SELECT
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Groups g WITH(NOLOCK) ON
						a.entityType1 = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
				LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
a.entityId1 > 1 AND (a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
				UNION
				SELECT
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN Users u WITH(NOLOCK) ON
						o.entityType = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND o.isUser = 1
						AND o.userOrGroupId = u.userId
				UNION
				SELECT
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN Groups g WITH(NOLOCK) ON
						o.entityType = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND o.isUser = 0
						AND o.userOrGroupId = g.groupId
				UNION
				SELECT
					cga.clientId clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Users u WITH(NOLOCK) ON
						a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
					LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
(a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
				UNION
				SELECT
					cga.clientId clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Groups g WITH(NOLOCK) ON
						a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
					LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
(a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
				-- Handling of a scenario, Company users / groups are associated with the parent Hypervisor client / subclient (VM group).
				-- We need to include the VMs which are backed up using that Hypervisor parent into the Company's smart client group.
				UNION
				SELECT CP.componentNameId
				FROM UMSecurityAssociations Sec (NOLOCK)
					INNER JOIN Users U
						ON Sec.isUser = 1 AND Sec.userOrGroupId = U.userID
AND Sec.entityType1 = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId1 = A.clientId)
							AND (Sec.entityId2 = 0 OR Sec.entityId2 = A.appTypeId)
							AND (Sec.entityId3 = 0 OR Sec.entityId3 = A.instance)
							AND (Sec.entityId4 = 0 OR Sec.entityId4 = A.backupset)
							AND (Sec.entityId5 = 0 OR Sec.entityId5 = A.id)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
					LEFT OUTER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)
						ON Sec.roleId = RPE.roleId
						AND Sec.permissionId = 0
				WHERE
Sec.permissionId IN (1, 2)
OR RPE.permissionId IN (1, 2)
				UNION
				SELECT CP.componentNameId
				FROM UMSecurityAssociations Sec (NOLOCK)
					INNER JOIN Groups G
						ON Sec.isUser = 0 AND Sec.userOrGroupId = G.groupId
AND Sec.entityType1 = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId1 = A.clientId)
							AND (Sec.entityId2 = 0 OR Sec.entityId2 = A.appTypeId)
							AND (Sec.entityId3 = 0 OR Sec.entityId3 = A.instance)
							AND (Sec.entityId4 = 0 OR Sec.entityId4 = A.backupset)
							AND (Sec.entityId5 = 0 OR Sec.entityId5 = A.id)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
					LEFT OUTER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)
						ON Sec.roleId = RPE.roleId
						AND Sec.permissionId = 0
				WHERE
Sec.permissionId IN (1, 2)
OR RPE.permissionId IN (1, 2)
				UNION
				SELECT CP.componentNameId
				FROM UMOwners Sec (NOLOCK)
					INNER JOIN Users U
						ON Sec.isUser = 1 AND Sec.userOrGroupId = U.userID
AND Sec.entityType = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId = A.clientId)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
				UNION
				SELECT CP.componentNameId
				FROM UMOwners Sec (NOLOCK)
					INNER JOIN Groups G
						ON Sec.isUser = 0 AND Sec.userOrGroupId = G.groupId
AND Sec.entityType = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId = A.clientId)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
				-- Sometimes, the tenant admin user / group of the company does not have any manual / explicit security association on the Hyper-V.
				-- But the Hyper-V still belongs to the Company (its tagged with the company). In such a corner case, we still have to pull in the
				-- VMs into the Company's CG based on the Hyper-V's company Id tagging. (TR: 201027-119).
				UNION
				SELECT
					CP.componentNameId
				FROM @InCompanies Comp
					INNER JOIN APP_CompanyEntities ACE (NOLOCK)
ON (Comp.id = ACE.companyId) AND (ACE.entityType = 3)
					INNER JOIN APP_Application A (NOLOCK)
ON (A.clientId = ACE.entityId) AND (A.appTypeId = 106)
					INNER JOIN APP_ClientProp CP (NOLOCK)
ON (CP.attrName = 'Last Backup Subclient') AND (CAST(A.id AS VARCHAR(10)) = CP.attrVal) AND (CP.modified = 0)
	END
	ELSE
	BEGIN
		-- Given client
		;WITH Providers(companyId) AS
		(
			SELECT
				c.id
			FROM  @InCompanies c
			UNION
			SELECT
				p.id
			FROM UMDSProviders p WITH(NOLOCK)
				INNER JOIN @InCompanies c ON
					c.id = p.ownerCompany
					AND p.serviceType = 2		-- UMDS_PROVIDER_ACTIVE_DIR
		)
		,Users(userId) AS (
			SELECT DISTINCT
				u.id
			FROM Providers c
				INNER JOIN UMUsers u WITH(NOLOCK) ON
					u.umDSproviderId = c.companyId
					AND (u.flags & 1) <> 0
		)
		,Groups(groupId) AS (
			SELECT DISTINCT
				g.id groupId
			FROM Providers c
				INNER JOIN UMGroups g WITH(NOLOCK) ON
					g.umdsProviderId = c.companyId
		)
			INSERT INTO @clientIds
				SELECT
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Users u WITH(NOLOCK) ON
						a.entityType1 = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
				LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
a.entityId1 = @inClientId AND (a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
				UNION
				SELECT
					a.entityId1 clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Groups g WITH(NOLOCK) ON
						a.entityType1 = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
				LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
a.entityId1 = @inClientId AND (a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
				UNION
				SELECT
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN Users u WITH(NOLOCK) ON
						o.entityType = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND o.isUser = 1
						AND o.userOrGroupId = u.userId
						AND o.entityId = @inClientId
				UNION
				SELECT
					o.entityId clientId
				FROM UMOwners o WITH(NOLOCK)
					INNER JOIN Groups g WITH(NOLOCK) ON
						o.entityType = 3		-- ENTITY_TYPE_CLIENT_ENTITY
						AND o.isUser = 0
						AND o.userOrGroupId = g.groupId
						AND o.entityId = @inClientId
				UNION
				SELECT
					cga.clientId clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Users u WITH(NOLOCK) ON
						a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
						AND a.isUser = 1
						AND a.userOrGroupId = u.userId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
					LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
(a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
					AND cga.clientId = @inClientId
				UNION
				SELECT
					cga.clientId clientId
				FROM UMSecurityAssociations a WITH(NOLOCK)
					INNER JOIN Groups g WITH(NOLOCK) ON
						a.entityType1 = 28		-- ENTITY_TYPE_CLIENT_GROUP_ENTITY
						AND a.isUser = 0
						AND g.groupId = a.userOrGroupId
						AND (
							@inSCGId = 0
							OR a.entityId1 <> @inSCGId		-- avoid the chicken / egg security inheritance when refreshing SCG Rules
						)
					INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
						cga.clientGroupId = a.entityId1
					LEFT JOIN UMRolesWithPermissionsExpanded UMR WITH(NOLOCK) ON
						UMR.roleId=a.roleId
						AND a.permissionId=0
				WHERE
(a.permissionId in (1,2) OR ((UMR.permissionId in (1,2))))
					AND a.entityType2=0
					AND cga.clientId = @inClientId
				-- Handling of a scenario, Company users / groups are associated with the parent Hypervisor client / subclient (VM group).
				-- We need to include the VMs which are backed up using that Hypervisor parent into the Company's smart client group.
				UNION
				SELECT CP.componentNameId
				FROM UMSecurityAssociations Sec (NOLOCK)
					INNER JOIN Users U
						ON Sec.isUser = 1 AND Sec.userOrGroupId = U.userID
AND Sec.entityType1 = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId1 = A.clientId)
							AND (Sec.entityId2 = 0 OR Sec.entityId2 = A.appTypeId)
							AND (Sec.entityId3 = 0 OR Sec.entityId3 = A.instance)
							AND (Sec.entityId4 = 0 OR Sec.entityId4 = A.backupset)
							AND (Sec.entityId5 = 0 OR Sec.entityId5 = A.id)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
					LEFT OUTER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)
						ON Sec.roleId = RPE.roleId
						AND Sec.permissionId = 0
				WHERE
(Sec.permissionId IN (1, 2)
OR RPE.permissionId IN (1, 2))
					AND CP.componentNameId = @inClientId
				UNION
				SELECT CP.componentNameId
				FROM UMSecurityAssociations Sec (NOLOCK)
					INNER JOIN Groups G
						ON Sec.isUser = 0 AND Sec.userOrGroupId = G.groupId
AND Sec.entityType1 = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId1 = A.clientId)
							AND (Sec.entityId2 = 0 OR Sec.entityId2 = A.appTypeId)
							AND (Sec.entityId3 = 0 OR Sec.entityId3 = A.instance)
							AND (Sec.entityId4 = 0 OR Sec.entityId4 = A.backupset)
							AND (Sec.entityId5 = 0 OR Sec.entityId5 = A.id)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
					LEFT OUTER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)
						ON Sec.roleId = RPE.roleId
						AND Sec.permissionId = 0
				WHERE
(Sec.permissionId IN (1, 2)
OR RPE.permissionId IN (1, 2))
					AND CP.componentNameId = @inClientId
				UNION
				SELECT CP.componentNameId
				FROM UMOwners Sec (NOLOCK)
					INNER JOIN Users U
						ON Sec.isUser = 1 AND Sec.userOrGroupId = U.userID
AND Sec.entityType = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId = A.clientId)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
				WHERE
					CP.componentNameId = @inClientId
				UNION
				SELECT CP.componentNameId
				FROM UMOwners Sec (NOLOCK)
					INNER JOIN Groups G
						ON Sec.isUser = 0 AND Sec.userOrGroupId = G.groupId
AND Sec.entityType = 3
					INNER JOIN App_Application A (NOLOCK)
ON A.appTypeId = 106
							AND (Sec.entityId = A.clientId)
					INNER JOIN App_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
						AND CAST(A.id AS VARCHAR(10)) = CP.attrVal
						AND CP.modified = 0
				WHERE
					CP.componentNameId = @inClientId
				-- Sometimes, the tenant admin user / group of the company does not have any manual / explicit security association on the Hyper-V.
				-- But the Hyper-V still belongs to the Company (its tagged with the company). In such a corner case, we still have to pull in the
				-- VMs into the Company's CG based on the Hyper-V's company Id tagging. (TR: 201027-119).
				UNION
				SELECT
					CP.componentNameId
				FROM @InCompanies Comp
					INNER JOIN APP_CompanyEntities ACE (NOLOCK)
ON (Comp.id = ACE.companyId) AND (ACE.entityType = 3)
					INNER JOIN APP_Application A (NOLOCK)
ON (A.clientId = ACE.entityId) AND (A.appTypeId = 106)
					INNER JOIN APP_ClientProp CP (NOLOCK)
ON (CP.attrName = 'Last Backup Subclient') AND (CAST(A.id AS VARCHAR(10)) = CP.attrVal) AND (CP.modified = 0)
				WHERE (CP.componentNameId = @inClientId)
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2CompanyClientAssociations]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2CompanyClientAssociations' AND revision = '1.1.2.13')

  insert into GXDBVersions values(5, 'scgV2CompanyClientAssociations',  '1.1.2.13', 'scgV2CompanyClientAssociations', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
