

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientsWithStrikes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientsWithStrikes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientsWithStrikes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientsWithStrikes]
  delete from GXDBVersions where name = 'scgV2ClientsWithStrikes' and type = 5
END
GO

 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION scgV2ClientsWithStrikes(@operator VARCHAR(24), @compValue INT, @secCompValue INT, @inClientID INT, @inSCGId INT)
 RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
 -- WITH ENCRYPTION
 BEGIN
     -- Check if any special group to consider for data collection.
     -- Get the list of client group ids if exists
     DECLARE @opType INT = 0
     SELECT 	@opType = CASE @operator
     						WHEN '='            THEN 1
     						WHEN '!='           THEN 2
     						WHEN '<>'           THEN 2
     						WHEN '>'            THEN 3
     						WHEN '>='           THEN 4
     						WHEN '<'            THEN 5
     						WHEN '<='           THEN 6
     						WHEN 'BETWEEN'      THEN 7
     						WHEN 'NOT BETWEEN'  THEN 8
     						ELSE 0
     					END
    DECLARE @strikesPerClient AS TABLE (
		clientId INT,
		strikes INT,
		PRIMARY KEY (strikes, clientId)
	)
	IF (@inClientID = 0)
	BEGIN
		-- All Clients
		INSERT INTO @strikesPerClient
			SELECT
				SC.clientId,
				MAX(ISNULL(CAST(SCP.attrVal AS INT), 0))
			FROM APP_Application SC WITH(NOLOCK)
				LEFT JOIN APP_SubClientProp SCP WITH(NOLOCK) ON
					SC.id = SCP.componentNameId
					AND SCP.attrName = N'Consecutive Backup Failures Count'
					AND SCP.cs_attrName = CHECKSUM(N'Consecutive Backup Failures Count')
					AND SCP.modified = 0
			GROUP BY SC.clientId
	END
	ELSE
	BEGIN
		-- Given Client
		INSERT INTO @strikesPerClient
			SELECT
				SC.clientId,
				MAX(ISNULL(CAST(SCP.attrVal AS INT), 0))
			FROM APP_Application SC WITH(NOLOCK)
				LEFT JOIN APP_SubClientProp SCP WITH(NOLOCK) ON
					SC.clientId = @inClientID
					AND SC.id = SCP.componentNameId
					AND SCP.attrName = N'Consecutive Backup Failures Count'
					AND SCP.cs_attrName = CHECKSUM(N'Consecutive Backup Failures Count')
					AND SCP.modified = 0
			GROUP BY SC.clientId
	END
     IF @opType = 1 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes = @compValue
     END ELSE IF  @opType = 2 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes != @compValue
     END ELSE IF  @opType = 3 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes > @compValue
     END ELSE IF  @opType = 4 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes >= @compValue
     END ELSE IF  @opType = 5 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes < @compValue
     END ELSE IF  @opType = 6 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes <= @compValue
     END ELSE IF  @opType = 7 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes BETWEEN @compValue AND @secCompValue
     END ELSE IF  @opType = 8 BEGIN
         INSERT INTO @clientIds
             SELECT DISTINCT clientId FROM @strikesPerClient WHERE strikes NOT BETWEEN @compValue AND @secCompValue
     END
     RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientsWithStrikes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientsWithStrikes' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'scgV2ClientsWithStrikes',  '1.1.2.4', 'scgV2ClientsWithStrikes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
