

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientsWithLicenses.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: scgV2ClientsWithLicenses'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientsWithLicenses]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientsWithLicenses]
  delete from GXDBVersions where name = 'scgV2ClientsWithLicenses' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2ClientsWithLicenses(@operator varchar(16), @compValue XML,@inClientID INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @LicenseTypes TABLE (
		id	INT PRIMARY KEY
	)
	INSERT INTO @LicenseTypes (id)
		SELECT
			cg.value('@val', 'integer')
		FROM
			@compValue.nodes('/App_SCGRuleValueList/id')	l(cg)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- no licenses nothing to do
		RETURN
	END
	DECLARE @utcNow DATETIME =  GETUTCDATE()
	DECLARE @epoch DATETIME = '1970-01-01 00:00:00.000'
	IF (@inClientID=0 )
	BEGIN
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					i.clientId
				FROM APP_iDAName i WITH(NOLOCK)
					INNER JOIN LicUsage l WITH(NOLOCK) ON
						l.Cid = i.clientId
						AND l.appType = i.appTypeId
						AND l.optype = 'Install'
						AND (
							l.ExpiryDateUTC = @epoch
							OR l.ExpiryDateUTC > @utcNow
						)
					INNER JOIN @LicenseTypes lt ON
						lt.id = l.LicType
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id > 1
				EXCEPT
				SELECT DISTINCT
					i.clientId
				FROM APP_iDAName i WITH(NOLOCK)
					INNER JOIN LicUsage l WITH(NOLOCK) ON
						l.Cid = i.clientId
						AND l.appType = i.appTypeId
						AND l.optype = 'Install'
						AND (
							l.ExpiryDateUTC = @epoch
							OR l.ExpiryDateUTC > @utcNow
						)
					INNER JOIN @LicenseTypes lt ON
						lt.id = l.LicType
		END
	END
	ELSE
	BEGIN
		IF (@opType = 1)
		BEGIN
			INSERT INTO @clientIds
				SELECT DISTINCT
					i.clientId
				FROM APP_iDAName i WITH(NOLOCK)
					INNER JOIN LicUsage l WITH(NOLOCK) ON
						l.Cid = i.clientId
						AND l.appType = i.appTypeId
						AND l.optype = 'Install'
						AND (
							l.ExpiryDateUTC = @epoch
							OR l.ExpiryDateUTC > @utcNow
						)
					INNER JOIN @LicenseTypes lt ON
						lt.id = l.LicType
				WHERE
					i.clientId = @inClientID
		END
		ELSE
		BEGIN
			INSERT INTO @clientIds
				SELECT
					c.id clientId
				FROM APP_Client c WITH(READUNCOMMITTED)
				WHERE
					c.id = @inClientID
				EXCEPT
				SELECT DISTINCT
					i.clientId
				FROM APP_iDAName i WITH(NOLOCK)
					INNER JOIN LicUsage l WITH(NOLOCK) ON
						l.Cid = i.clientId
						AND l.appType = i.appTypeId
						AND l.optype = 'Install'
						AND (
							l.ExpiryDateUTC = @epoch
							OR l.ExpiryDateUTC > @utcNow
						)
					INNER JOIN @LicenseTypes lt ON
						lt.id = l.LicType
				WHERE
					i.clientId = @inClientID
		END
	END
	RETURN
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientsWithLicenses]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientsWithLicenses' AND revision = '1.1.10.2')

  insert into GXDBVersions values(5, 'scgV2ClientsWithLicenses',  '1.1.10.2', 'scgV2ClientsWithLicenses', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
