

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientsWithEnabledBackupSchedule.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientsWithEnabledBackupSchedule'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientsWithEnabledBackupSchedule]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientsWithEnabledBackupSchedule]
  delete from GXDBVersions where name = 'scgV2ClientsWithEnabledBackupSchedule' and type = 5
END
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2ClientsWithEnabledBackupSchedule(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	-- Variables for disabled activity
	DECLARE @jobsDisabled TINYINT = 0
	DECLARE @schedulesDisabled TINYINT = 0
	DECLARE @backupsDisabled TINYINT = 0
	-- Is all job activity disabled
	SELECT
		@jobsDisabled = 1
	FROM JMJobAction WITH(NOLOCK)
	WHERE
		opType = 1		-- CvOpType::ALLOPS
		AND action = 1
		AND clientId = 1
		AND appType = 0
		AND mediaAgentID = 1
		AND appId = 1
	IF (@jobsDisabled = 0)
	BEGIN
		-- Is all schedules disabled
		SELECT
			@schedulesDisabled = 1
		FROM JMJobAction WITH(NOLOCK)
		WHERE
			opType = 28		-- CvOpType::SCHEDULE
			AND action = 1
			AND clientId = 1
			AND appType = 0
			AND mediaAgentID = 1
			AND appId = 1
		IF (@schedulesDisabled = 0)
		BEGIN
			-- Is all backups disabled
			SELECT
				@backupsDisabled = 1
			FROM JMJobAction WITH(NOLOCK)
			WHERE
				opType = 4		-- CVOpType::BACKUP
				AND action = 1
				AND clientId = 1
				AND appType = 0
				AND mediaAgentID = 1
				AND appId = 1
				AND clientGroupId = 0
		END
	END
	-- Any activity disabled
	IF (@jobsDisabled = 1 OR @schedulesDisabled = 1 OR @backupsDisabled = 1)
	BEGIN
		IF (@compValue = 1)
		BEGIN
			-- true
			-- There are no clients with enabled backup schedules
			RETURN
		END
		ELSE
		BEGIN
			-- false
			IF (@inClientId = 0)
			BEGIN
				-- Yes all clients have disabled backup schedules
				INSERT INTO @clientIds (clientId)
					SELECT DISTINCT
						c.id
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
			END
			ELSE
			BEGIN
				-- Specific client
				INSERT INTO @clientIds (clientId)
					SELECT DISTINCT
						c.id
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND c.id = @inClientId
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
			END
			RETURN
		END
	END
	DECLARE @cgBackupsDisabled TABLE (
		cgId		INT PRIMARY KEY
	)
	-- Client Groups are only marked disabled with an actual row, if no row they are enabled
	INSERT INTO @cgBackupsDisabled (cgId)
		SELECT DISTINCT
			cg.id
		FROM APP_ClientGroup cg WITH(READUNCOMMITTED)
			INNER JOIN JMJobAction ja WITH(READUNCOMMITTED) ON
				ja.clientId = 1
				AND ja.mediaAgentID = 1
				AND ja.clientGroupId = cg.id
				AND ja.appType = 0
				AND ja.opType = 4			-- CVOpType::BACKUP. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
				AND (ja.action & 2) = 0		-- backup disabled
		WHERE
			cg.id <> @inSCGId		-- Exclude self - allows clients to leave this client group so that we do not inherit from self
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@compValue > 0)
		BEGIN
			-- true
			INSERT INTO @clientIds
				SELECT DISTINCT
					a.clientId
				FROM APP_Application a WITH(NOLOCK)
					INNER JOIN APP_Client c WITH(NOLOCK) ON
						a.clientId = c.id
						AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
						AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
						AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
						AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
						AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = a.backupSet
						AND bs.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
						i.id = a.instance
						AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					INNER JOIN (
						SELECT
							ae.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
							INNER JOIN TM_Task t WITH(NOLOCK) ON
								t.taskId = st.taskId
								AND t.disabled = 0
						UNION
						SELECT
							cga.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
							INNER JOIN TM_Task t WITH(NOLOCK) ON
								t.taskId = st.taskId
								AND t.disabled = 0
							INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
								cga.clientGroupId = ae.clientGroupId
					) t ON
						t.clientId = a.clientId
				EXCEPT	-- Clients backups disabled via setting
				SELECT
					q.clientId
				FROM (
						SELECT
							cga.clientId
						FROM @cgBackupsDisabled d
							INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
								cga.clientGroupId = d.cgId
						UNION	-- Include Clients with Backup disabled
						SELECT clientId FROM dbo.scgV2ClientBackupActivityEnabled('FALSE', 0, @inClientID, @inSCGId)
					) q
		END
		ELSE
		BEGIN
			-- false
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE
					(c.status & (2|4)) = 0					-- uninstalled/deleted/agentless client
					AND c.id > 1
				EXCEPT
				SELECT
					q.clientId
				FROM (
						SELECT DISTINCT
							a.clientId
						FROM APP_Application a WITH(NOLOCK)
							INNER JOIN APP_Client c WITH(NOLOCK) ON
								a.clientId = c.id
								AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
								AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
								AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
								AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
								AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
							INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
								bs.id = a.backupSet
								AND bs.name <> N'defaultDummyBackupSet'
							INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
								i.id = a.instance
								AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
							INNER JOIN (
								SELECT
									ae.clientId
								FROM TM_AssocEntity ae WITH(NOLOCK)
									INNER JOIN TM_SubTask st WITH(NOLOCK) ON
										ae.taskId = st.taskId
										AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
										AND ae.exclude = 0
									INNER JOIN TM_Task t WITH(NOLOCK) ON
										t.taskId = st.taskId
										AND t.disabled = 0
								UNION
								SELECT
									cga.clientId
								FROM TM_AssocEntity ae WITH(NOLOCK)
									INNER JOIN TM_SubTask st WITH(NOLOCK) ON
										ae.taskId = st.taskId
										AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
										AND ae.exclude = 0
									INNER JOIN TM_Task t WITH(NOLOCK) ON
										t.taskId = st.taskId
										AND t.disabled = 0
									INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
										cga.clientGroupId = ae.clientGroupId
							) t ON
								t.clientId = a.clientId
						EXCEPT	-- Clients backups disabled via setting
						SELECT
							q.clientId
						FROM (
								SELECT
									cga.clientId
								FROM @cgBackupsDisabled d
									INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
										cga.clientGroupId = d.cgId
								UNION	-- Include Clients with Backup disabled
								SELECT clientId FROM dbo.scgV2ClientBackupActivityEnabled('FALSE', 0, @inClientID, @inSCGId)
							) q
					) q
		END
	END
	ELSE
	BEGIN
		-- Specific clientId
		IF (@compValue > 0)
		BEGIN
			-- true
			INSERT INTO @clientIds
				SELECT DISTINCT
					a.clientId
				FROM APP_Application a WITH(NOLOCK)
					INNER JOIN APP_Client c WITH(NOLOCK) ON
						a.clientId = c.id
						AND c.id = @inClientId
						AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
						AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
						AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
						AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
						AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = a.backupSet
						AND bs.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
						i.id = a.instance
						AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					INNER JOIN (
						SELECT
							ae.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
							INNER JOIN TM_Task t WITH(NOLOCK) ON
								t.taskId = st.taskId
								AND t.disabled = 0
						WHERE
							ae.clientId = @inClientId
						UNION
						SELECT
							cga.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
							INNER JOIN TM_Task t WITH(NOLOCK) ON
								t.taskId = st.taskId
								AND t.disabled = 0
							INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
								cga.clientGroupId = ae.clientGroupId
						WHERE
							cga.clientId = @inClientId
					) t ON
						t.clientId = a.clientId
				EXCEPT	-- Clients backups disabled via setting
				SELECT
					q.clientId
				FROM (
						SELECT
							cga.clientId
						FROM @cgBackupsDisabled d
							INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
								cga.clientGroupId = d.cgId
						WHERE
							cga.clientId = @inClientId
						UNION	-- Include Clients with Backup disabled
						SELECT clientId FROM dbo.scgV2ClientBackupActivityEnabled('FALSE', 0, @inClientID, @inSCGId) WHERE clientId = @inClientId
					) q
		END
		ELSE
		BEGIN
			-- false
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE
					(c.status & (2|4)) = 0					-- uninstalled/deleted/agentless client
					AND c.id = @inClientId
				EXCEPT
				SELECT
					q.clientId
				FROM (
						SELECT DISTINCT
							a.clientId
						FROM APP_Application a WITH(NOLOCK)
							INNER JOIN APP_Client c WITH(NOLOCK) ON
								a.clientId = c.id
								AND c.id = @inClientId
								AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
								AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
								AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
								AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
								AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
							INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
								bs.id = a.backupSet
								AND bs.name <> N'defaultDummyBackupSet'
							INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
								i.id = a.instance
								AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
							INNER JOIN (
								SELECT
									ae.clientId
								FROM TM_AssocEntity ae WITH(NOLOCK)
									INNER JOIN TM_SubTask st WITH(NOLOCK) ON
										ae.taskId = st.taskId
										AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
										AND ae.exclude = 0
									INNER JOIN TM_Task t WITH(NOLOCK) ON
										t.taskId = st.taskId
										AND t.disabled = 0
								WHERE
									ae.clientId = @inClientId
								UNION
								SELECT
									cga.clientId
								FROM TM_AssocEntity ae WITH(NOLOCK)
									INNER JOIN TM_SubTask st WITH(NOLOCK) ON
										ae.taskId = st.taskId
										AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
										AND ae.exclude = 0
									INNER JOIN TM_Task t WITH(NOLOCK) ON
										t.taskId = st.taskId
										AND t.disabled = 0
									INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
										cga.clientGroupId = ae.clientGroupId
								WHERE
									cga.clientId = @inClientId
							) t ON
								t.clientId = a.clientId
						EXCEPT	-- Clients backups disabled via setting
						SELECT
							q.clientId
						FROM (
								SELECT
									cga.clientId
								FROM @cgBackupsDisabled d
									INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
										cga.clientGroupId = d.cgId
								WHERE
									cga.clientId = @inClientId
								UNION	-- Include Clients with Backup disabled
								SELECT clientId FROM dbo.scgV2ClientBackupActivityEnabled('FALSE', 0, @inClientID, @inSCGId) WHERE clientId = @inClientId
							) q
					) q
		END
	END
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientsWithEnabledBackupSchedule]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientsWithEnabledBackupSchedule' AND revision = '')

  insert into GXDBVersions values(5, 'scgV2ClientsWithEnabledBackupSchedule',  '', 'scgV2ClientsWithEnabledBackupSchedule', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
