

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientsWithBackupSchedule.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientsWithBackupSchedule'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientsWithBackupSchedule]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientsWithBackupSchedule]
  delete from GXDBVersions where name = 'scgV2ClientsWithBackupSchedule' and type = 5
END
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2ClientsWithBackupSchedule(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
AS
BEGIN
	-- Check for All Clients or All ClientGroups
	DECLARE @allClients TINYINT = 0
	DECLARE @allClientGroups TINYINT = 0
	SELECT TOP 1
		@allClients = 1
	FROM TM_AssocEntity ae WITH(NOLOCK)
		INNER JOIN TM_SubTask st WITH(NOLOCK) ON
			ae.taskId = st.taskId
			AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
			AND ae.exclude = 0
			AND ae.assocType = 2
	-- Table for AllClientGroup Clients
	DECLARE @cgClients TABLE (
		clientId	INT PRIMARY KEY
	)
	IF (@allClients = 0)
	BEGIN
		-- Is All ClientGroups Set?
		SELECT TOP 1
			@allClientGroups = 1
		FROM TM_AssocEntity ae WITH(NOLOCK)
			INNER JOIN TM_SubTask st WITH(NOLOCK) ON
				ae.taskId = st.taskId
				AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
				AND ae.exclude = 0
				AND ae.assocType = 27
		IF (@allClientGroups = 1)
		BEGIN
			-- Create a list of all clients in ClientGroups
			IF (@inClientId = 0)
			BEGIN
				INSERT INTO @cgClients (clientId)
					SELECT DISTINCT
						c.id
					FROM APP_ClientGroupAssoc cga WITH(NOLOCK)
						INNER JOIN APP_Application a WITH(NOLOCK) ON
							a.clientId = cga.clientId
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
			END
			ELSE
			BEGIN
				-- Specific client
				INSERT INTO @cgClients (clientId)
					SELECT DISTINCT
						c.id
					FROM APP_ClientGroupAssoc cga WITH(NOLOCK)
						INNER JOIN APP_Application a WITH(NOLOCK) ON
							a.clientId = cga.clientId
							AND a.clientId = @inClientId
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
			END
		END
	END
	IF (@allClients = 1)
	BEGIN
		-- Operate on all clients in Commcell
		IF (@compValue > 0)
		BEGIN
			-- true
			IF (@inClientId = 0)
			BEGIN
				INSERT INTO @clientIds
					SELECT DISTINCT
						c.id
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					WHERE
						c.id = @inClientId
			END
		END
		ELSE
		BEGIN
			-- false
			IF (@inClientId = 0)
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(NOLOCK)
					WHERE
						(c.status & (2|4)) = 0					-- uninstalled/deleted/agentless client
					EXCEPT
					SELECT
						c.id
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
			END
			ELSE
			BEGIN
				INSERT INTO @clientIds
					SELECT
						c.id
					FROM APP_Client c WITH(NOLOCK)
					WHERE
						(c.status & (2|4)) = 0					-- uninstalled/deleted/agentless client
						AND c.id = @inClientId
					EXCEPT
					SELECT
						c.id
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					WHERE
						c.id = @inClientId
			END
		END
		-- Done all clients processed
		RETURN
	END
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@compValue > 0)
		BEGIN
			-- true
			INSERT INTO @clientIds
				SELECT			-- add clients associated to All ClientGroups if any
					clientId
				FROM @cgClients
				UNION
				SELECT
					a.clientId
				FROM APP_Application a WITH(NOLOCK)
					INNER JOIN APP_Client c WITH(NOLOCK) ON
						a.clientId = c.id
						AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
						AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
						AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
						AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
						AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = a.backupSet
						AND bs.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
						i.id = a.instance
						AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					INNER JOIN (
						SELECT
							ae.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
						UNION ALL
						SELECT
							cga.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
							INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
								cga.clientGroupId = ae.clientGroupId
					) t ON
						t.clientId = a.clientId
		END
		ELSE
		BEGIN
			-- false
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE
					(c.status & (2|4)) = 0					-- uninstalled/deleted/agentless client
				EXCEPT
				SELECT
					clientId
				FROM (
					SELECT
						a.clientId
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					WHERE
						EXISTS (
							SELECT
								ae.clientId
							FROM TM_AssocEntity ae WITH(NOLOCK)
								INNER JOIN TM_SubTask st WITH(NOLOCK) ON
									ae.taskId = st.taskId
									AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
									AND ae.exclude = 0
							WHERE
								ae.clientId = a.clientId
							UNION ALL
							SELECT
								cga.clientId
							FROM TM_AssocEntity ae WITH(NOLOCK)
								INNER JOIN TM_SubTask st WITH(NOLOCK) ON
									ae.taskId = st.taskId
									AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
									AND ae.exclude = 0
								INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
									cga.clientGroupId = ae.clientGroupId
							WHERE
								cga.clientId = a.clientId
						)
					UNION ALL
					SELECT			-- remove clients associated to All ClientGroups if any
						clientId
					FROM @cgClients
				) q
		END
	END
	ELSE
	BEGIN
		-- Specific clientId
		IF (@compValue > 0)
		BEGIN
			-- true
			INSERT INTO @clientIds
				SELECT			-- add clients associated to All ClientGroups if any
					clientId
				FROM @cgClients
				UNION
				SELECT
					a.clientId
				FROM APP_Application a WITH(NOLOCK)
					INNER JOIN APP_Client c WITH(NOLOCK) ON
						c.id = @inClientId
						AND a.clientId = c.id
						AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
						AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
						AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
						AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
						AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = a.backupSet
						AND bs.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
						i.id = a.instance
						AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
				WHERE
					EXISTS (
						SELECT
							ae.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
						WHERE
							ae.clientId = a.clientId
						UNION ALL
						SELECT
							cga.clientId
						FROM TM_AssocEntity ae WITH(NOLOCK)
							INNER JOIN TM_SubTask st WITH(NOLOCK) ON
								ae.taskId = st.taskId
								AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
								AND ae.exclude = 0
							INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
								cga.clientGroupId = ae.clientGroupId
						WHERE
							cga.clientId = a.clientId
					)
		END
		ELSE
		BEGIN
			-- false
			INSERT INTO @clientIds
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
				WHERE
					(c.status & (2|4)) = 0					-- uninstalled/deleted/agentless client
					AND c.id = @inClientId
				EXCEPT
				SELECT
					clientId
				FROM (
					SELECT
						a.clientId
					FROM APP_Application a WITH(NOLOCK)
						INNER JOIN APP_Client c WITH(NOLOCK) ON
							c.id = @inClientId
							AND a.clientId = c.id
							AND (c.[status] & (2|4)) = 0										-- uninstalled/deleted/agentless client
							AND dbo.IsSubClientValid(a.appTypeId, a.subclientStatus, 0) = 1		-- subclient is valid
							AND (a.subclientStatus & 536) != 536								-- not an indexing subclient
							AND (a.subclientStatus & (16|32)) = 0								-- do not backup flags are no set
							AND (a.subclientStatus & (2|4)) = 0									-- subclient is not deleted
						INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
							bs.id = a.backupSet
							AND bs.name <> N'defaultDummyBackupSet'
						INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
							i.id = a.instance
							AND i.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					WHERE
						EXISTS (
							SELECT
								ae.clientId
							FROM TM_AssocEntity ae WITH(NOLOCK)
								INNER JOIN TM_SubTask st WITH(NOLOCK) ON
									ae.taskId = st.taskId
									AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
									AND ae.exclude = 0
							WHERE
								ae.clientId = a.clientId
							UNION ALL
							SELECT
								cga.clientId
							FROM TM_AssocEntity ae WITH(NOLOCK)
								INNER JOIN TM_SubTask st WITH(NOLOCK) ON
									ae.taskId = st.taskId
									AND st.subTaskType = 2		--SUB_TASK_TYPE_BACKUP
									AND ae.exclude = 0
								INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
									cga.clientGroupId = ae.clientGroupId
							WHERE
								cga.clientId = a.clientId
						)
					UNION ALL
					SELECT			-- remove clients associated to All ClientGroups if any
						clientId
					FROM @cgClients
				) q
		END
	END
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientsWithBackupSchedule]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientsWithBackupSchedule' AND revision = '')

  insert into GXDBVersions values(5, 'scgV2ClientsWithBackupSchedule',  '', 'scgV2ClientsWithBackupSchedule', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
