

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientsWithAssociatedSchdPolicy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientsWithAssociatedSchdPolicy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientsWithAssociatedSchdPolicy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientsWithAssociatedSchdPolicy]
  delete from GXDBVersions where name = 'scgV2ClientsWithAssociatedSchdPolicy' and type = 5
END
GO

 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION scgV2ClientsWithAssociatedSchdPolicy(@operator VARCHAR(24), @compValue INT, @inClientId INT, @inSCGId INT)
 RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
--- WITH ENCRYPTION
 BEGIN
	DECLARE @opType INT = 0
	SELECT 	@opType = CASE @operator
						WHEN '=' THEN 1
						WHEN '!=' THEN 2
						WHEN '<>' THEN 2
						ELSE 0
					END
	IF (@opType = 0)
	BEGIN
		RETURN
	END
	DECLARE @spClients TABLE (
		id			INT,
		exclude		INT,
		PRIMARY KEY (id, exclude)
	)
	IF (@inClientId = 0)
	BEGIN
		INSERT INTO @spClients (id, exclude)
			SELECT
				c.id,
				CASE
					WHEN ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0 THEN ae.exclude	-- only exclude at the client group level
					ELSE 0
				END
			FROM TM_Task t WITH(NOLOCK)
				INNER JOIN TM_AssocEntity ae WITH(NOLOCK) ON
					ae.taskId = t.taskId
					AND ae.clientGroupId <> 0
				INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
					cga.clientGroupId = ae.clientGroupId
				INNER JOIN APP_Client c WITH(NOLOCK) ON
					c.id = cga.clientId
					AND (c.status & (2|4)) = 0 -- not uninstalled/deleted client
			WHERE
				t.taskType = 4	-- TASK_TYPE_SCHEDULE_POLICY
				AND t.taskId =  @compValue
			UNION
			SELECT
				c.id,
				CASE
					WHEN ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0 THEN ae.exclude	-- only exclude at the client level
					ELSE 0
				END
			FROM TM_Task t WITH(NOLOCK)
				INNER JOIN TM_AssocEntity ae WITH(NOLOCK) ON
					ae.taskId = t.taskId
					AND ae.clientId <> 0
				INNER JOIN APP_Client c WITH(NOLOCK) ON
					c.id = ae.clientId
					AND (c.status & (2|4)) = 0 -- not uninstalled/deleted client
			WHERE
				t.taskType = 4	-- TASK_TYPE_SCHEDULE_POLICY
				AND t.taskId =  @compValue
	END
	ELSE
	BEGIN
		INSERT INTO @spClients (id, exclude)
			SELECT
				c.id,
				CASE
					WHEN ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0 THEN ae.exclude	-- only exclude at the client group level
					ELSE 0
				END
			FROM TM_Task t WITH(NOLOCK)
				INNER JOIN TM_AssocEntity ae WITH(NOLOCK) ON
					ae.taskId = t.taskId
					AND ae.clientGroupId <> 0
				INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
					cga.clientGroupId = ae.clientGroupId
				INNER JOIN APP_Client c WITH(NOLOCK) ON
					c.id = cga.clientId
					AND (c.status & (2|4)) = 0 -- not uninstalled/deleted client
			WHERE
				c.id = @inClientId
				AND t.taskType = 4	-- TASK_TYPE_SCHEDULE_POLICY
				AND t.taskId =  @compValue
			UNION
			SELECT
				c.id,
				CASE
					WHEN ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0 THEN ae.exclude	-- only exclude at the client level
					ELSE 0
				END
			FROM TM_Task t WITH(NOLOCK)
				INNER JOIN TM_AssocEntity ae WITH(NOLOCK) ON
					ae.taskId = t.taskId
					AND ae.clientId <> 0
				INNER JOIN APP_Client c WITH(NOLOCK) ON
					c.id = ae.clientId
					AND (c.status & (2|4)) = 0 -- not uninstalled/deleted client
			WHERE
				c.id = @inClientId
				AND t.taskType = 4	-- TASK_TYPE_SCHEDULE_POLICY
				AND t.taskId =  @compValue
	END
	IF (@opType = 1)
	BEGIN
		INSERT INTO @clientIds
			SELECT
				c.id
			FROM @spClients c
			WHERE
				c.exclude = 0
			EXCEPT
			SELECT
				c.id
			FROM @spClients c
			WHERE
				c.exclude = 1
	END
	ELSE
	BEGIN
		-- @opType = 2
		INSERT INTO @clientIds
			SELECT
				c.id clientId
			FROM APP_Client c WITH(READUNCOMMITTED)
			WHERE
				c.id > 1
				AND (c.status & (2|4)) = 0 -- not uninstalled/deleted client
			EXCEPT
			SELECT
				c.id clientId
			FROM (
					SELECT
						c.id
					FROM @spClients c
					WHERE
						c.exclude = 0
					EXCEPT
					SELECT
						c.id
					FROM @spClients c
					WHERE
						c.exclude = 1
				) c
	END
 	RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientsWithAssociatedSchdPolicy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientsWithAssociatedSchdPolicy' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'scgV2ClientsWithAssociatedSchdPolicy',  '1.1.2.1', 'scgV2ClientsWithAssociatedSchdPolicy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
