

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientsWithAssociatedSP.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientsWithAssociatedSP'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientsWithAssociatedSP]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientsWithAssociatedSP]
  delete from GXDBVersions where name = 'scgV2ClientsWithAssociatedSP' and type = 5
END
GO

 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION scgV2ClientsWithAssociatedSP(@operator VARCHAR(24), @compValue INT,@inClientId INT, @inSCGId INT)
 RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
--- WITH ENCRYPTION
 BEGIN
	-- Get Defaults
	DECLARE @defAppId INT
	DECLARE @defInstId INT
	SELECT
		@defAppId = id,
		@defInstId = instance
	FROM APP_Application a WITH(NOLOCK)
	WHERE
		a.appTypeId = 1000		-- CV_APPTYPE_COMMSRVMGMT
	IF EXISTS (
		SELECT
			1
		FROM JMJobAction J WITH(NOLOCK)
		WHERE
			J.opType = 4
			AND J.ACTION = 1
			AND J.ClientId = 1
			AND J.mediaAgentID = 1
			AND J.AppType = 0
			AND J.AppId = @defAppId
			AND J.clientGroupId = 0
			AND J.instanceId = @defInstId
	)
	BEGIN
		-- CS Activity disabled
		RETURN
	END
	DECLARE @tmp_table TABLE
	(
		clientid    INTEGER,
		subclientId INTEGER,
		appTypeId   INTEGER,
		instanceId	INTEGER,
		PRIMARY KEY (clientId, subclientId)
	)
	IF (@inClientId = 0)
	BEGIN
		-- All Clients
		IF (@compValue > 0) BEGIN
			-- true
			INSERT INTO @tmp_table
				SELECT DISTINCT
					CL.id,
					SC.id,
					SC.appTypeId,
					SC.instance
				FROM APP_Application AS SC WITH(NOLOCK)
					INNER JOIN APP_Client AS CL WITH(NOLOCK) ON
						SC.clientId = CL.id
						AND (CL.status & (2|4)) = 0						-- uninstalled/deleted/agentless client
						AND (SC.subclientStatus & 536) != 536			-- not an indexing subclient
						AND (SC.subclientStatus & (16|32)) = 0			-- do not backup flags are no set
						AND (SC.subclientStatus & (2|4)) = 0			-- subclient is not deleted
						AND dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1	-- subclient is valid
					INNER JOIN APP_BackupSetName AS BS WITH(NOLOCK) ON
						BS.id = SC.backupSet
						AND BS.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName AS INST WITH(NOLOCK) ON
						INST.id = SC.instance
						AND INST.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					INNER JOIN APP_iDAType AS IDA WITH(NOLOCK) ON
						IDA.type = SC.appTypeId
					LEFT JOIN APP_SubClientProp p WITH(NOLOCK) ON
						p.componentNameId = SC.id
						AND p.attrName IN (N'Index SubClient', N'DDB Backup')
						AND p.modified = 0
						AND p.attrVal = N'1'
						AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))
				WHERE
					p.id IS NULL
					AND SC.dataArchGrpID <> 1	-- there is associated storage policy
					--AND SC.logArchGrpID <> 1	-- filesystem / cloud agents a log is not required... databases agents do we need to check appType and make sure assigned???
		END
		ELSE
		BEGIN
			-- false
			INSERT INTO @tmp_table
				SELECT DISTINCT
					CL.id,
					SC.id,
					SC.appTypeId,
					SC.instance
				FROM APP_Application AS SC WITH(NOLOCK)
					INNER JOIN APP_Client AS CL WITH(NOLOCK) ON
						SC.clientId = CL.id
						AND (CL.status & (2|4)) = 0						-- uninstalled/deleted/agentless client
						AND (SC.subclientStatus & 536) != 536			-- not an indexing subclient
						AND (SC.subclientStatus & (16|32)) = 0			-- do not backup flags are no set
						AND (SC.subclientStatus & (2|4)) = 0			-- subclient is not deleted
						AND dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1	-- subclient is valid
					INNER JOIN APP_BackupSetName AS BS WITH(NOLOCK) ON
						BS.id = SC.backupSet
						AND BS.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName AS INST WITH(NOLOCK) ON
						INST.id = SC.instance
						AND INST.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					INNER JOIN APP_iDAType AS IDA WITH(NOLOCK) ON
						IDA.type = SC.appTypeId
					LEFT JOIN APP_SubClientProp p WITH(NOLOCK) ON
						p.componentNameId = SC.id
						AND p.attrName IN (N'Index SubClient', N'DDB Backup')
						AND p.modified = 0
						AND p.attrVal = N'1'
						AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))
				WHERE
					p.id IS NULL
					AND SC.dataArchGrpID = 1	-- there is NO associated storage policy
					--AND SC.logArchGrpID = 1	-- filesystem / cloud agents a log is not required... databases agents do we need to check appType and make sure assigned???
		END
	END
	ELSE
	BEGIN
		-- Individual Client
		IF (@compValue > 0) BEGIN
			-- true
			INSERT INTO @tmp_table
				SELECT DISTINCT
					CL.id,
					SC.id,
					SC.appTypeId,
					SC.instance
				FROM APP_Application AS SC WITH(NOLOCK)
					INNER JOIN APP_Client AS CL WITH(NOLOCK) ON
						SC.clientId = CL.id
						AND CL.ID = @inClientId
						AND (CL.status & (2|4)) = 0						-- uninstalled/deleted/agentless client
						AND (SC.subclientStatus & 536) != 536			-- not an indexing subclient
						AND (SC.subclientStatus & (16|32)) = 0			-- do not backup flags are no set
						AND (SC.subclientStatus & (2|4)) = 0			-- subclient is not deleted
						AND dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1	-- subclient is valid
					INNER JOIN APP_BackupSetName AS BS WITH(NOLOCK) ON
						BS.id = SC.backupSet
						AND BS.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName AS INST WITH(NOLOCK) ON
						INST.id = SC.instance
						AND INST.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					INNER JOIN APP_iDAType AS IDA WITH(NOLOCK) ON
						IDA.type = SC.appTypeId
					LEFT JOIN APP_SubClientProp p WITH(NOLOCK) ON
						p.componentNameId = SC.id
						AND p.attrName IN (N'Index SubClient', N'DDB Backup')
						AND p.modified = 0
						AND p.attrVal = N'1'
						AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))
				WHERE
					p.id IS NULL
					AND SC.dataArchGrpID <> 1	-- there is associated storage policy
					--AND SC.logArchGrpID <> 1	-- filesystem / cloud agents a log is not required... databases agents do we need to check appType and make sure assigned???
		END
		ELSE
		BEGIN
			-- false
			INSERT INTO @tmp_table
				SELECT DISTINCT
					CL.id,
					SC.id,
					SC.appTypeId,
					SC.instance
				FROM APP_Application AS SC WITH(NOLOCK)
					INNER JOIN APP_Client AS CL WITH(NOLOCK) ON
						SC.clientId = CL.id
						AND CL.ID = @inClientId
						AND (CL.status & (2|4)) = 0						-- uninstalled/deleted/agentless client
						AND (SC.subclientStatus & 536) != 536			-- not an indexing subclient
						AND (SC.subclientStatus & (16|32)) = 0			-- do not backup flags are no set
						AND (SC.subclientStatus & (2|4)) = 0			-- subclient is not deleted
						AND dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1	-- subclient is valid
					INNER JOIN APP_BackupSetName AS BS WITH(NOLOCK) ON
						BS.id = SC.backupSet
						AND BS.name <> N'defaultDummyBackupSet'
					INNER JOIN APP_InstanceName AS INST WITH(NOLOCK) ON
						INST.id = SC.instance
						AND INST.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')
					INNER JOIN APP_iDAType AS IDA WITH(NOLOCK) ON
						IDA.type = SC.appTypeId
					LEFT JOIN APP_SubClientProp p WITH(NOLOCK) ON
						p.componentNameId = SC.id
						AND p.attrName IN (N'Index SubClient', N'DDB Backup')
						AND p.modified = 0
						AND p.attrVal = N'1'
						AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))
				WHERE
					p.id IS NULL
					AND SC.dataArchGrpID = 1	-- there is NO associated storage policy
					--AND SC.logArchGrpID = 1	-- filesystem / cloud agents a log is not required... databases agents do we need to check appType and make sure assigned???
		END
	END
	-- Remove activity disabled subclients from the resultset
	-- Separated DELETE operation into multiple passes for better performance
	-- Client / AppType disabled
	DELETE S
	FROM @tmp_table S
		INNER JOIN JMJobAction J WITH(NOLOCK) ON
			J.opType = 4
			AND J.ACTION = 1
			AND J.clientId = S.ClientId
			AND J.appType IN (S.AppTypeId, 0)
			AND J.mediaAgentID = 1
	-- Instance disabled
	DELETE S
	FROM @tmp_table S
		INNER JOIN JMJobAction J WITH(NOLOCK) ON
			J.opType = 4
			AND J.ACTION = 1
			AND J.instanceId = S.instanceId
			AND J.mediaAgentID = 1
			AND J.clientId = 1
			AND J.AppType = 0
			AND J.appId = @defAppId
			AND J.clientGroupId = 0
	-- SubClient disabled
	DELETE S
	FROM @tmp_table S
		INNER JOIN JMJobAction J WITH(NOLOCK) ON
			J.opType = 4
			AND J.ACTION = 1
			AND J.appId = S.subclientId
			AND J.mediaAgentID = 1
			AND J.clientId = 1
			AND J.AppType = 0
	-- ClientGroup disabled
	-- separated into table variable, SQL confused and picking a bad plan
	DECLARE @cgClients TABLE (
		clientId	INT PRIMARY KEY
	)
	INSERT INTO @cgClients
		SELECT
			CGA.clientId
		FROM APP_ClientGroupAssoc CGA WITH(NOLOCK)
			INNER JOIN JMJobAction J WITH(NOLOCK) ON
				CGA.clientGroupId = J.clientGroupId
				AND J.opType = 4
				AND J.ACTION = 1
				AND J.ClientId = 1
				AND J.mediaAgentID = 1
				AND J.AppType = 0
		GROUP BY
			CGA.clientId
	DELETE S
	FROM  @tmp_table S
		INNER JOIN @cgClients c ON
			c.clientId = S.clientId
	-- Create result set of all clients remaining
	INSERT INTO @clientIds
		SELECT DISTINCT
			clientId
		FROM @tmp_table
 	RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientsWithAssociatedSP]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientsWithAssociatedSP' AND revision = '1.1.6.5')

  insert into GXDBVersions values(5, 'scgV2ClientsWithAssociatedSP',  '1.1.6.5', 'scgV2ClientsWithAssociatedSP', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
