

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientWithIndexingV2List.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientWithIndexingV2List'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientWithIndexingV2List]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientWithIndexingV2List]
  delete from GXDBVersions where name = 'scgV2ClientWithIndexingV2List' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION scgV2ClientWithIndexingV2List(@operator VARCHAR(24), @compValue XML, @inClientId INT, @inSCGId INT)
RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
BEGIN
	DECLARE @opType INT= 0;
	SELECT @opType = CASE @operator
						WHEN '='         THEN 1
						WHEN '!='        THEN 2
						WHEN '<>'        THEN 2
						ELSE 0
					END
	IF(@opType = 0)
	BEGIN
		RETURN;
	END
	-- Get static enumerations list
	DECLARE @IdxV2Types TABLE (
		id		INT PRIMARY KEY,
		name	NVARCHAR(64)
	)
	INSERT INTO @IdxV2Types (id, name)
		SELECT
			t.value('@value', 'INT'),
			t.value('@label', 'NVARCHAR(64)')
		FROM (
				SELECT
					CAST(gp.value AS XML) val
				FROM GXGlobalParam gp WITH(NOLOCK)
				WHERE
					gp.name =  N'SCGV2_IndexingV2_Enumerations'
			) v
			CROSS APPLY v.val.nodes('/App_SCGGetEnumValuesResp/enumValues') d(t)
	DECLARE @rcnt INT = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- nothing to do - no data
		RETURN
	END
	DECLARE @IdxV2 TABLE (
		id		INT PRIMARY KEY
	)
	INSERT INTO @IdxV2 (id)
		SELECT cg.value('@val', 'int')
		FROM @compValue.nodes('/App_SCGRuleValueList/id') l(cg);
	SET @rcnt = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		-- nothing to do - no data
		RETURN
	END
	DECLARE @valueSet NVARCHAR(5)
	IF (@opType = 1)
	BEGIN
		SET @valueSet = N'1'
	END
	ELSE
	BEGIN
		SET @valueSet = N'0'
	END
	IF (@inClientId = 0)
	BEGIN
		INSERT INTO @clientIds (clientId)
			SELECT DISTINCT
				c.id
			FROM APP_Client c WITH(NOLOCK)
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					c.id = cp.componentNameId
					AND cp.modified = 0
				INNER JOIN @IdxV2Types t ON
					t.name = cp.attrName
				INNER JOIN @IdxV2 r ON
					r.id = t.id
			WHERE
				cp.attrVal = @valueSet
	END
	ELSE
	BEGIN
		INSERT INTO @clientIds (clientId)
			SELECT DISTINCT
				c.id
			FROM APP_Client c WITH(NOLOCK)
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					c.id = cp.componentNameId
					AND cp.modified = 0
				INNER JOIN @IdxV2Types t ON
					t.name = cp.attrName
				INNER JOIN @IdxV2 r ON
					r.id = t.id
			WHERE
				cp.attrVal = @valueSet
				AND c.id = @inClientId
	END
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientWithIndexingV2List]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientWithIndexingV2List' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'scgV2ClientWithIndexingV2List',  '1.1.2.1', 'scgV2ClientWithIndexingV2List', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
