

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientOnlineInLast30Days.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientOnlineInLast30Days'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientOnlineInLast30Days]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientOnlineInLast30Days]
  delete from GXDBVersions where name = 'scgV2ClientOnlineInLast30Days' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION scgV2ClientOnlineInLast30Days(@operator VARCHAR(24), @compValue INT,@inClientId INT, @inSCGId INT)
	RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
	---- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @now				INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @ClientTimes TABLE (
			clientId			INT PRIMARY KEY,
			maxLastOnlineTime	INT,
			maxLastOfflineTime	INT
		)
		IF (@inClientId=0)
		BEGIN
			INSERT INTO @ClientTimes
				SELECT
					q.clientId,
					MAX(q.MaxLastOnlineTime) MaxLastOnlineTime,
					MAX(q.maxLastOfflineTime) maxLastOfflineTime
				FROM (
						SELECT
							ctc.ToClientId clientId,
							MIN(ctc.lastOnlineTime) MaxLastOnlineTime,
							MAX(ctc.lastOfflineTime) maxLastOfflineTime
						FROM CCRClientToClient ctc WITH(NOLOCK)
						WHERE
							ctc.FromClientId = 2    -- only want status of CS client to client
							AND ctc.serviceType = 0
						GROUP BY
							ctc.ToClientId
						UNION ALL
						SELECT
							ctc.FromClientId clientId,
							MAX(ctc.lastOnlineTime) MaxLastOnlineTime,
							MAX(ctc.lastOfflineTime) maxLastOfflineTime
						FROM CCRClientToClient ctc WITH(NOLOCK)
						WHERE
							ctc.ToClientId = 2    -- only want status of CS client from client
							AND ctc.serviceType = 0
						GROUP BY
							ctc.FromClientId
					) q
				GROUP BY
					q.clientId
			IF (@compValue > 0)
			BEGIN
				-- true
				INSERT @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM
						APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN (
							SELECT
								ctc.clientId,
								CASE
									WHEN ISNULL(ctc.maxLastOfflineTime,0) < ISNULL(ctc.MaxLastOnlineTime,0) THEN 1
 	                                WHEN ISNULL(ctc.maxLastOfflineTime,0)=0 AND ISNULL(ctc.MaxLastOnlineTime,0)=0 THEN -1
									ELSE 0  -- offline
								END isOnline,
								CASE
									WHEN ctc.maxLastOnlineTime > 0 THEN (@now - ctc.maxLastOnlineTime) / 86400  --(24*3600) day converted to seconds
									ELSE NULL	-- not computable
								END daysSinceLastOnline
							FROM @ClientTimes ctc
						) q ON
							c.id = q.clientId
					WHERE
						c.id > 1
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
						AND q.clientId IS NOT NULL      -- No Entry / New clients  Mark them Offline
						AND (
							(
								q.isOnline = 1							-- currently online
							)
							OR (
								q.isOnline = 0							-- currently offline
								AND q.daysSinceLastOnline IS NOT NULL	-- online time is computable
								AND q.daysSinceLastOnline <= 30			-- was online in the last 30 days or less
							)
						)
			END
			ELSE
			BEGIN
				-- false
				INSERT @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM
						APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id > 1
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
					EXCEPT
					SELECT DISTINCT
						c.id clientId
					FROM
						APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN (
							SELECT
								ctc.clientId,
								CASE
									WHEN ISNULL(ctc.maxLastOfflineTime,0) < ISNULL(ctc.MaxLastOnlineTime,0) THEN 1
 	                                WHEN ISNULL(ctc.maxLastOfflineTime,0)=0 AND ISNULL(ctc.MaxLastOnlineTime,0)=0 THEN -1
									ELSE 0  -- offline
								END isOnline,
								CASE
									WHEN ctc.maxLastOnlineTime > 0 THEN (@now - ctc.maxLastOnlineTime) / 86400  --(24*3600) day converted to seconds
									ELSE NULL	-- not computable
								END daysSinceLastOnline
							FROM @ClientTimes ctc
						) q ON
							c.id = q.clientId
					WHERE
						c.id > 1
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
						AND q.clientId IS NOT NULL      -- No Entry / New clients  Mark them Offline
						AND (
							(
								q.isOnline = 1							-- currently online
							)
							OR (
								q.isOnline = 0							-- currently offline
								AND q.daysSinceLastOnline IS NOT NULL	-- online time is computable
								AND q.daysSinceLastOnline <= 30			-- was online in the last 30 days or less
							)
						)
			END
		END
		ELSE
		BEGIN
			INSERT INTO @ClientTimes
				SELECT
					q.clientId,
					MAX(q.MaxLastOnlineTime) MaxLastOnlineTime,
					MAX(q.maxLastOfflineTime) maxLastOfflineTime
				FROM (
						SELECT
							ctc.ToClientId clientId,
							MAX(ctc.LastOnlineTime) MaxLastOnlineTime,
							MAX(ctc.lastOfflineTime) maxLastOfflineTime
						FROM CCRClientToClient ctc WITH(NOLOCK)
						WHERE
							ctc.FromClientId = 2    -- only want status of CS client to client
							AND ctc.serviceType = 0
							AND ctc.ToClientId = @InClientID
						GROUP BY
							ctc.ToClientId
						UNION ALL
						SELECT
							ctc.FromClientId clientId,
							MAX(ctc.LastOnlineTime) MaxLastOnlineTime,
							MAX(ctc.lastOfflineTime) maxLastOfflineTime
						FROM CCRClientToClient ctc WITH(NOLOCK)
						WHERE
							ctc.ToClientId = 2    -- only want status of CS client from client
							AND ctc.serviceType = 0
							AND ctc.FromClientId = @InClientID
						GROUP BY
							ctc.FromClientId
					) q
				GROUP BY
					q.clientId
			IF (@compValue > 0)
			BEGIN
				-- true
                INSERT @clientIds
				SELECT DISTINCT
						c.id clientId
					FROM
						APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN (
							SELECT
								ctc.clientId,
								CASE
									WHEN ISNULL(ctc.maxLastOfflineTime,0) < ISNULL(ctc.MaxLastOnlineTime,0) THEN 1
 	                                WHEN ISNULL(ctc.maxLastOfflineTime,0)=0 AND ISNULL(ctc.MaxLastOnlineTime,0)=0 THEN -1
									ELSE 0  -- offline
								END isOnline,
								CASE
									WHEN ctc.maxLastOnlineTime > 0 THEN (@now - ctc.maxLastOnlineTime) / 86400  --(24*3600) day converted to seconds
									ELSE NULL	-- not computable
								END daysSinceLastOnline
							FROM @ClientTimes ctc
						) q ON
							c.id = q.clientId
					WHERE
						c.id = @InClientID
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
						AND q.clientId IS NOT NULL      -- No Entry / New clients  Mark them Offline
						AND (
							(
								q.isOnline = 1							-- currently online
							)
							OR (
								q.isOnline = 0							-- currently offline
								AND q.daysSinceLastOnline IS NOT NULL	-- online time is computable
								AND q.daysSinceLastOnline <= 30			-- was online in the last 30 days or less
							)
						)
			END
			ELSE
			BEGIN
				-- false
				INSERT @clientIds
					SELECT DISTINCT
						c.id clientId
					FROM
						APP_Client c WITH(READUNCOMMITTED)
					WHERE
						c.id = @InClientID
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
					EXCEPT
					SELECT DISTINCT
						c.id clientId
					FROM
						APP_Client c WITH(READUNCOMMITTED)
						LEFT OUTER JOIN (
							SELECT
								ctc.clientId,
								CASE
									WHEN ISNULL(ctc.maxLastOfflineTime,0) < ISNULL(ctc.MaxLastOnlineTime,0) THEN 1
 	                                WHEN ISNULL(ctc.maxLastOfflineTime,0)=0 AND ISNULL(ctc.MaxLastOnlineTime,0)=0 THEN -1
									ELSE 0  -- offline
								END isOnline,
								CASE
									WHEN ctc.maxLastOnlineTime > 0 THEN (@now - ctc.maxLastOnlineTime) / 86400  --(24*3600) day converted to seconds
									ELSE NULL	-- not computable
								END daysSinceLastOnline
							FROM @ClientTimes ctc
						) q ON
							c.id = q.clientId
					WHERE
						c.id = @InClientID
						AND (c.status & (2|4)) = 0		-- CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
						AND q.clientId IS NOT NULL      -- No Entry / New clients  Mark them Offline
						AND (
							(
								q.isOnline = 1							-- currently online
							)
							OR (
								q.isOnline = 0							-- currently offline
								AND q.daysSinceLastOnline IS NOT NULL	-- online time is computable
								AND q.daysSinceLastOnline <= 30			-- was online in the last 30 days or less
							)
						)
			END
		END
		RETURN
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientOnlineInLast30Days]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientOnlineInLast30Days' AND revision = '1.1.2.6')

  insert into GXDBVersions values(5, 'scgV2ClientOnlineInLast30Days',  '1.1.2.6', 'scgV2ClientOnlineInLast30Days', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
