

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientNeedsUpdates.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: scgV2ClientNeedsUpdates'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientNeedsUpdates]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientNeedsUpdates]
  delete from GXDBVersions where name = 'scgV2ClientNeedsUpdates' and type = 5
END
GO

	--Baseline values:
	--UNKNOWN = 0
	--UP_TO_DATE = 1
	--NEEDS_UPDATE = 2
	--AHEAD_OF_CACHE = 4
	--NOT_APPLICABLE = 8
	--HAS_DIAGNOSTIC_UPDATES = 16
	--BASELINE_TOCS_BELOW      0x1000  //Compare to CS
SET QUOTED_IDENTIFIER ON
GO
	CREATE FUNCTION scgV2ClientNeedsUpdates(@operator VARCHAR(24), @compValue INT, @inClientID INT, @inSCGId INT)
	RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
	AS
	BEGIN
		IF (@inClientID = 0)
		BEGIN
			-- All Clients
			IF (@compValue > 0)
			BEGIN
				-- true
				INSERT INTO @clientIds
					SELECT
						p.ClientId
					FROM
						simInstalledPackages p WITH(READUNCOMMITTED)
					WHERE
						(p.Baseline & (2 + 4096)) > 0
					GROUP BY
						p.ClientId
					EXCEPT
						SELECT
							v.componentNameId
						FROM
							APP_ClientProp v WITH(READUNCOMMITTED)
						WHERE
							v.attrName = N'Virtual client' AND v.attrVal = N'1' AND v.modified = 0
			END
			ELSE
			BEGIN
				-- false
				INSERT INTO @clientIds
					SELECT
						p.ClientId
					FROM
						simInstalledPackages p WITH(READUNCOMMITTED)
					GROUP BY
						p.ClientId
					HAVING
						p.ClientId NOT IN (SELECT
												upd.ClientId
											FROM
												simInstalledPackages upd WITH(READUNCOMMITTED)
											WHERE
												upd.ClientId = p.ClientId
											AND
												(upd.Baseline = 0 OR (upd.Baseline & 2) > 0 OR (upd.Baseline & 0x1000) > 0))
					EXCEPT
						SELECT
							v.componentNameId
						FROM
							APP_ClientProp v WITH(READUNCOMMITTED)
						WHERE
							v.attrName = N'Virtual client'
							AND v.attrVal = N'1'
							AND v.modified = 0
			END
		END
		ELSE
		BEGIN
			-- Given Client
			IF (@compValue > 0)
			BEGIN
				-- true
				INSERT INTO @clientIds
					SELECT
						p.ClientId
					FROM
						simInstalledPackages p WITH(READUNCOMMITTED)
					WHERE
						(p.Baseline & (2 + 4096)) > 0
						AND p.ClientId = @inClientID
					GROUP BY
						p.ClientId
					EXCEPT
						SELECT
							v.componentNameId
						FROM
							APP_ClientProp v WITH(READUNCOMMITTED)
						WHERE
							v.attrName = N'Virtual client'
							AND v.attrVal = N'1'
							AND v.modified = 0
							AND v.componentNameId = @inClientID
			END
			ELSE
			BEGIN
				-- false
				INSERT INTO @clientIds
					SELECT
						p.ClientId
					FROM
						simInstalledPackages p WITH(READUNCOMMITTED)
					WHERE
						p.ClientId = @inClientID
					GROUP BY
						p.ClientId
					HAVING
						p.ClientId NOT IN (SELECT
												upd.ClientId
											FROM
												simInstalledPackages upd WITH(READUNCOMMITTED)
											WHERE
												upd.ClientId = p.ClientId
											AND
												(upd.Baseline = 0 OR (upd.Baseline & 2) > 0 OR (upd.Baseline & 0x1000) > 0))
					EXCEPT
						SELECT
							v.componentNameId
						FROM
							APP_ClientProp v WITH(READUNCOMMITTED)
						WHERE
							v.attrName = N'Virtual client'
							AND v.attrVal = N'1'
							AND v.modified = 0
							AND v.componentNameId = @inClientID
			END
		END
		RETURN
	END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientNeedsUpdates]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientNeedsUpdates' AND revision = '1.1.2.5.20.1')

  insert into GXDBVersions values(5, 'scgV2ClientNeedsUpdates',  '1.1.2.5.20.1', 'scgV2ClientNeedsUpdates', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
