

--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgV2ClientMeetsSLA.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgV2ClientMeetsSLA'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgV2ClientMeetsSLA]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgV2ClientMeetsSLA]
  delete from GXDBVersions where name = 'scgV2ClientMeetsSLA' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION scgV2ClientMeetsSLA(@operator VARCHAR(24), @compValue INT,@inClientId INT, @inSCGId INT)
	RETURNS @clientIds TABLE (clientId INT PRIMARY KEY)
	AS
	BEGIN
		DECLARE @opType INT = 0
	    DECLARE @csSLADays INT=0
	    DECLARE @SLADays INT=0
		SELECT 	@opType = CASE @operator
							WHEN '=' THEN 1
							WHEN '!=' THEN 2
							WHEN '<>' THEN 2
							ELSE 0
						END
		IF (@opType = 0)
		BEGIN
			RETURN
		END
		-- SLA status
		--	1. MetSLA
		--	2. Missed
		--	3. Excluded from SLA
		DECLARE @slaStatus INT
		IF (@opType = 1)
		BEGIN
			-- meets SLA
			SET @slaStatus = 1
		END
		ELSE
		BEGIN
			-- missed SLA
			SET @slaStatus = 2
		END
	IF (@inClientId=0)
	BEGIN
		IF (@compValue <= 0)
		BEGIN
			-- any SLA Day, system config
			SET @csSLADays  = 30		-- default if not set for the CS
			SELECT
				@csSLADays = cscp.longVal
			FROM APP_ComponentProp cscp WITH (NOLOCK)
			WHERE
				cscp.componentType = 1
				AND cscp.componentId = 2
				AND cscp.propertyTypeId = 3300
				AND cscp.modified = 0
				AND cscp.longVal > 0
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM RptSLAClient c WITH (NOLOCK)
					LEFT OUTER JOIN (
						SELECT
							cga.clientId,
							MIN(CASE
								WHEN cp.longVal IS NOT NULL THEN cp.longVal
								ELSE @csSLADays
								END
							) slaDays
						FROM APP_ClientGroupAssoc cga WITH (NOLOCK)
							LEFT OUTER JOIN APP_ComponentProp cp WITH (NOLOCK) ON
								cp.componentId = cga.clientGroupId
								AND cp.componentType = 8
								AND cp.propertyTypeId = 3300
								AND cp.modified = 0
								AND cp.longVal > 0
						GROUP BY
							cga.clientId
					) s ON
						s.clientId = c.clientId
				WHERE
					c.status = @slaStatus
					AND (
						(s.slaDays IS NOT NULL AND s.slaDays = c.days)
						OR (s.slaDays IS NULL AND c.days = @csSLADays)
					)
		END
		ELSE
		BEGIN
			-- specific SLA Day
			SET @SLADays  = @compValue
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM RptSLAClient c WITH (NOLOCK)
				WHERE
					c.status = @slaStatus
					AND c.days = @SLADays
		END
	END
	ELSE
	BEGIN
		IF (@compValue <= 0)
		BEGIN
			-- any SLA Day, system config
			SET @csSLADays  = 30		-- default if not set for the CS
			SELECT
				@csSLADays = cscp.longVal
			FROM APP_ComponentProp cscp WITH (NOLOCK)
			WHERE
				cscp.componentType = 1
				AND cscp.componentId = 2
				AND cscp.propertyTypeId = 3300
				AND cscp.modified = 0
				AND cscp.longVal > 0
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM RptSLAClient c WITH (NOLOCK)
					LEFT OUTER JOIN (
						SELECT
							cga.clientId,
							MIN(CASE
								WHEN cp.longVal IS NOT NULL THEN cp.longVal
								ELSE @csSLADays
								END
							) slaDays
						FROM APP_ClientGroupAssoc cga WITH (NOLOCK)
							LEFT OUTER JOIN APP_ComponentProp cp WITH (NOLOCK) ON
								cp.componentId = cga.clientGroupId
								AND cp.componentType = 8
								AND cp.propertyTypeId = 3300
								AND cp.modified = 0
								AND cp.longVal > 0
						GROUP BY
							cga.clientId
					) s ON
						s.clientId = c.clientId
				WHERE
					c.status = @slaStatus AND c.clientId=@InClientID
					AND (
						(s.slaDays IS NOT NULL AND s.slaDays = c.days)
						OR (s.slaDays IS NULL AND c.days = @csSLADays)
					)
		END
		ELSE
		BEGIN
			-- specific SLA Day
			SET @SLADays  = @compValue
			INSERT INTO @clientIds
				SELECT DISTINCT
					c.clientId
				FROM RptSLAClient c WITH (NOLOCK)
				WHERE
					c.status = @slaStatus
					AND c.days = @SLADays
					AND c.clientId=@InClientID
		END
	END
		RETURN
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgV2ClientMeetsSLA]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgV2ClientMeetsSLA' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'scgV2ClientMeetsSLA',  '1.1.2.3', 'scgV2ClientMeetsSLA', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
